% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Final_Functions.R
\name{GxEscreen}
\alias{GxEscreen}
\title{Gene-Environment Interaction: Genome-wide Screen}
\usage{
GxEscreen(dat, geno, nsim = 1e+05, K = 7)
}
\arguments{
\item{dat}{a data frame with covariate information. Col 1 should be phenotype,
col 2 should be environmental factor, col 3 and later should be additional covariates}

\item{geno}{a genotype matrix with 0-1-2 coding}

\item{nsim}{the number of replicates in obtaining the p-value (standard 1e5)}

\item{K}{the number of knots used to control the flexibility in modeling GxE interaction}
}
\value{
a vector containing the p-value from the LRT associated with each SNP
}
\description{
Function to test for the joint genetic and gene-environment
interaction effects for a set of variant using a LRT model
}
\examples{
GxEscreen(cov_example, geno_example, nsim=1e5, K=7)
}
