% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confirm_edges.R
\name{confirm_edges}
\alias{confirm_edges}
\title{Confirm Edges}
\usage{
confirm_edges(object, Rnew, method, alpha)
}
\arguments{
\item{object}{An object of class \code{ggmncv}}

\item{Rnew}{Matrix. A correlation matrix of dimensions \emph{p} by \emph{p}.}

\item{method}{Character string. A correction method for multiple comparison
(defaults to \code{fdr}). Can be abbreviated. See \link[stats]{p.adjust}.}

\item{alpha}{Numeric. Significance level (defaults to \code{0.05}).}
}
\value{
An object of class \code{ggmncv}, including:

\itemize{

\item{\strong{P}}: Matrix of confirmed edges (partial correlations)

\item{\strong{adj}}: Matrix of confirmed edges (adjacency)

}
}
\description{
Confirmatory hypothesis testing of edges that were initially
             detected with data-driven model selection.
}
\details{
The basic idea is to merge exploration with confirmation
\insertCite{@see for example,  @rodriguez_williams_rast_mulder_2020}{GGMncv}.
This is accomplished by testing those edges (in an independent dataset)
that were initially detected via data driven model selection.

Confirmatory hypothesis testing follows the approach described in
\insertCite{jankova2015confidence;textual}{GGMncv}: (1)
graphical lasso is computed with lambda fixed to  \mjseqn{\lambda = \sqrt{log(p)/n}},
(2) the de-sparsified estimator is computed, and then (3) \emph{p}-values are
obtained for the de-sparsified estimator.
}
\examples{
Y <- na.omit(bfi[,1:25])

Y_explore <- Y[1:1000,]

Y_confirm <- Y[1001:nrow(Y),]

fit <- ggmncv(cor(Y_explore),
              n = nrow(Y_explore),
              progress = FALSE)

confirm <- confirm_edges(fit,
                         Rnew = cor(Y_confirm),
                         method = "fdr",
                         alpha = 0.05)
}
\references{
\insertAllCited{}
}
