% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_map.R
\name{plot_map}
\alias{plot_map}
\title{Choropleth map}
\usage{
plot_map(
  data,
  var,
  time,
  type = "cov",
  pop = NULL,
  pt = 1e+05,
  area = NULL,
  map = NULL,
  map_area = NULL,
  by_year = NULL,
  aggregate_time = "year",
  aggregate_time_fun = "mean",
  transform = "identity",
  title = NULL,
  var_label = NULL,
  palette = NULL,
  centering = NULL,
  bins = NULL,
  bins_method = "quantile",
  bins_label = NULL,
  ...
)
}
\arguments{
\item{data}{Data frame containing equally spaced (daily, weekly, monthly)
covariate or case observations for one or multiple locations.}

\item{var}{Name of the column identifying the variable to be plotted.}

\item{time}{Name of the variable that identifies the temporal dimension
of the data frame. Its values must be in date format ("yyyy-mm-dd")
representing the day of observation for daily data, the first day of the
week for weekly, or the first day of the month for monthly observations.}

\item{type}{Character that specifies the type of variable in \code{var}.
Possible values include 'cov' (covariate, default), 'counts' (case counts),
and 'inc' (case incidence). If \code{type='inc'}, \code{pop} is required.}

\item{pop}{Character identifying the variable name for population. Only needed
if \code{type='inc'}.}

\item{pt}{Scale of the person-time (default 100,000) for incidence rates.}

\item{area}{Name of variable that identifies the different locations
(e.g., areal units) for which a time series is available.}

\item{map}{Name of the sf object corresponding to the spatial unit
specified in 'area'.}

\item{map_area}{Name of the variable that identifies the different locations
(e.g., areal units) in the map object. If not specified, it assumes the same
name as in \code{area}.}

\item{by_year}{Deprecated. Use 'aggregate_time' instead.}

\item{aggregate_time}{Temporal scale for visualization and aggregation. Options
include "all" (across all time points) and "year" (default).}

\item{aggregate_time_fun}{Character indicating the function to be used
in the aggregation over time for \code{type="cov"}. Options are "mean" (default),
"median", "sum". For case counts and incidence, "sum" is always applied.}

\item{transform}{Character, defaults to "identity" (i.e., no transformation).
Transforms the color ramp for better visualization. Useful options include
"log10p1" \code{log10(x+1)} for case counts and incidence with 0s, or
any of the in-built ggplot2 options such as  "log10" \code{log10(x)}, "log1p" \code{log(x+1)},
and "sqrt" \code{sqrt(x)} (check all possible options using \code{?scale_y_continuous}).}

\item{title}{Optional title of the plot.}

\item{var_label}{Character with a custom name for the case or covariate variable.}

\item{palette}{GHR, RColorBrewer or colorspace palette. Use "-" before the palette
name (e.g., "-Reds") to reverse it.}

\item{centering}{Numerical or "median", defaults to NULL. If set,
it centers the palette on that value.}

\item{bins}{Number of bins for categorization of numerical variables.
Defaults to NULL (no binning).}

\item{bins_method}{Method to compute the bins, only used when \code{bins} is not NULL.
Possible values are "quantile" (default) and "equal".}

\item{bins_label}{Optional labels for the bins. They must have the same length
as the number of bins. Defaults to NULL (default interval labels).}

\item{...}{Additional aesthetics to be passed to geom_sf. Possible values
include \code{colour} (e.g., \code{colour="black"}), linewidth (e.g., \code{linewidth=0.1}),
linetype (e.g., \code{linetype=2}), and alpha (e.g., \code{alpha=0.8}).}
}
\value{
A ggplot2 choropleth map.
}
\description{
Plots a choropleth map of covariates, case counts, or incidence
rates.
}
\examples{
# Load data
library("sf")
data("dengue_MS")
data("map_MS")

# Temporal average of a covariate
plot_map(data = dengue_MS, 
         var = "tmin",  
         time = "date",       
         type = "cov",
         area = "micro_code",  
         map = map_MS,         
         map_area = "code",   
         aggregate_time = "all",
         aggregate_time_fun = "mean",         
         palette ="Reds",
         var_label= "Min Temp.")

# Categorical covariate
plot_map(data = dengue_MS, 
         var = "biome_name",        
         time = "date",      
         area = "micro_code", 
         aggregate_time = "all",
         map = map_MS,       
         map_area = "code",  
         palette ="Viridis",
         var_label= "Biome")

# Case counts by year (log)
dengue_MS |>
  plot_map(var = "dengue_cases",    
           time = "date",    
           type = "counts",
           area = "micro_code", 
           pop = "population",
           map = map_MS,   
           map_area = "code",
           palette = "Reds",
           transform = "log10p1")

# Case incidence by year, binned
plot_map(dengue_MS,
         var = "dengue_cases", 
         type = "inc",
         time = "date",
         area = "micro_code",
         pop = "population",
         pt = 1000,
         map = map_MS, 
         map_area = "code",
         bins = 5,   
         palette = "Viridis")
}
