% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mia.R
\name{gmdh.mia}
\alias{gmdh.mia}
\title{GMDH MIA with PRESS like external criteria.}
\usage{
gmdh.mia(X, y, prune = 150)
}
\arguments{
\item{X}{matrix with N columns and M rows, containing independent variables in the model.}

\item{y}{vector or matrix containing dependent variable in the model.}

\item{prune}{an integer whose recommended minimum value is the number of initial regressors. \cr
The maximum value will depend on the available RAM. It is recommended to work with the maximum value, but it can be computationally very expensive. \cr
prune is the selected number of neurons from layer i to layer i+1. The resulting layer i+1 has prune(prune-1)/2 neurons; for example with prune=150, the resulting nerurons will be 11.175}
}
\value{
An object of class mia.
}
\description{
Performs GMDH MIA with PRESS like selection criteria.
}
\examples{
set.seed(123)
x <- matrix(data = c(rnorm(1000)), ncol = 5, nrow = 200)
colnames(x) <- c("a", "b", "c", "d", "e")
y <- matrix(data = c(10 + x[, "a"] * x[, "e"]^3), ncol = 1)
colnames(y) <- "y"
x.test <- x[1:10, ]
y.test <- y[1:10]
x <- x[-c(1:10), ]
y <- y[-c(1:10)]

mod <- gmdh.mia(X = x, y = y, prune = 5)
pred <- predict(mod, x.test)
summary(sqrt((pred - y.test)^2))

}
\references{
Farlow, S.J. (1981): "The GMDH algorithm of Ivakhnenko", The American Statistician, 35(4), pp. 210-215. <doi:10.2307/2683292> \cr
Ivakhnenko A.G. (1968): "The Group Method of Data Handling - A Rival of the Method of Stochastic Approximation", Soviet Automatic Control, 13(3), pp. 43-55
}
