% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/GOCore.R
\name{GOChord}
\alias{GOChord}
\title{Displays the relationship between genes and terms.}
\usage{
GOChord(data, title, space, gene.order, gene.size, gene.space, nlfc = 1,
  lfc.col, lfc.min, lfc.max, ribbon.col, border.size, process.label)
}
\arguments{
\item{data}{The matrix represents the binary relation (1= is related to, 0=
is not related to) between a set of genes (rows) and processes (columns); a
column for the logFC of the genes is optional}

\item{title}{The title (on top) of the plot}

\item{space}{The space between the chord segments of the plot}

\item{gene.order}{A character vector defining the order of the displayed gene
labels}

\item{gene.size}{The size of the gene labels}

\item{gene.space}{The space between the gene labels and the segement of the
logFC}

\item{nlfc}{Defines the number of logFC columns (default=1)}

\item{lfc.col}{The fill color for the logFC specified in the following form:
c(color for low values, color for the mid point, color for the high values)}

\item{lfc.min}{Specifies the minimium value of the logFC scale (default = -3)}

\item{lfc.max}{Specifies the maximum value of the logFC scale (default = 3)}

\item{ribbon.col}{The background color of the ribbons}

\item{border.size}{Defines the size of the ribbon borders}

\item{process.label}{The size of the legend entries}
}
\description{
The GOChord function generates a circularly composited overview
  of selected/specific genes and their assigned processes or terms. More
  generally, it joins genes and processes via ribbons in an intersection-like
  graph. The input can be generated with the \code{\link{chord_dat}}
  function.
}
\details{


The \code{gene.order} argument has three possible options: "logFC",
  "alphabetical", "none". Actually, the options are quite self- explanatory.

  Another argument which needs a bit more explanation is \code{nlfc}.
  Differential expression analysis can be performed for multiple conditions
  and/or batches. Therefore, the data frame contains more than one logFC
  value per gene. To adjust to this situation the \code{nlfc} argument is
  used. It is a numeric value and it defines the number of logFC columns
  within the binary membership matrix. The default is "1" assuming that most
  of the time only one contrast is considered.
}
\examples{
\dontrun{
#Load the included dataset
data(EC)

#Generating the binary matrix
chord<-chord_dat(circ,EC$genes,EC$process)

#Creating the chord plot
GOChord(chord)

#Creating the chord plot genes ordered by logFC and a different logFC color scale
GOChord(chord,space=0.02,gene.order='logFC',lfc.col=c('red','black','cyan'))
}
}
\seealso{
\code{\link{chord_dat}}
}

