% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_w_corr.R
\name{compute_w_corr}
\alias{compute_w_corr}
\title{Compute weighted correlation}
\usage{
compute_w_corr(w, confounders, weights)
}
\arguments{
\item{w}{A vector of exposure values for the observed data.}

\item{confounders}{A data.frame of observational confounders.}

\item{weights}{A vector of weights for each observation data.}
}
\value{
A vector of covariate balance.
}
\description{
Computes weighted correlation of the observational data based on weights
achieved by Gaussian Process.
}
\examples{

set.seed(124)
mydata <- generate_synthetic_data(sample_size = 200)
weights <- runif(nrow(mydata))
compute_w_corr(mydata$treat,
               mydata[, 3:ncol(mydata)],
               weights)

}
