% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GPPFourier.R
\name{demod}
\alias{demod}
\title{Complex demodulation}
\usage{
demod(x, dt, w1 = 2 * pi/1, filttype = c("MA", "bw"), Nf, nf = 1, freq)
}
\arguments{
\item{x}{Vector containing time series observations at constant sampling interval}

\item{dt}{Time step of time series. Arbitrary units. Class \code{Numeric} or \code{difftime}}

\item{w1}{Carrier frequency. Inverse unit of \code{dt}.}

\item{filttype}{Filter type to be applied for low pass filtering. "MA" for moving average; "bw" for butterworth filter.}

\item{Nf}{Moving average filter width}

\item{nf}{Number of iterative applications of moving average filter. To remove filter bandwidth.}

\item{freq}{Cut-off frequency of Buttersworth filter}
}
\description{
Retreive the time varying amplitude of a signal with fixed carrier frequency by complex demodulation
}
\details{
no details
}
