% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotBrier.R
\name{plotBrier}
\alias{plotBrier}
\title{Plot curves of time-dependent Brier score}
\usage{
plotBrier(
  dat,
  datMCMC,
  dat.new = NULL,
  time.star = NULL,
  xlab = "Time",
  ylab = "Brier score",
  PTCM = TRUE,
  ...
)
}
\arguments{
\item{dat}{input data as a list containing survival data sub-list
\code{survObj} with two vectors (\code{event} and \code{time}), clinical
variable matrix \code{x0}, cluster-specific covariates \code{X}, and
proportions data matrix \code{proportion}}

\item{datMCMC}{returned object from the main function \code{GPTCM()}}

\item{dat.new}{input data for out-sample prediction, with the same format
as \code{dat}}

\item{time.star}{largest time for survival prediction}

\item{xlab}{a title for the x axis}

\item{ylab}{a title for the y axis}

\item{PTCM}{logical value for adding survival prediction by the PTCM}

\item{...}{other parameters}
}
\value{
A \code{ggplot2::ggplot} object. See \code{?ggplot2::ggplot} for more
details of the object.
}
\description{
Predict time-dependent Brier scores based on different survival models
}
\examples{

# simulate data
set.seed(123)
n <- 200 # subjects
p <- 10 # variable selection predictors
L <- 3 # cell types
dat <- simData(n, p, L)

# run a Bayesian GPTCM model: GPTCM-Ber2
fit <- GPTCM(dat, nIter = 5, burnin = 0)

\donttest{
plotBrier(dat, datMCMC = fit, PTCM = FALSE)
}

}
\references{
Zhao Z, Kızılaslan F, Wang S, Zucknick M (2025). \emph{Generalized promotion time cure model: A new modeling framework to identify cell-type-specific genes and improve survival prognosis}. arXiv:2509.01001
}
