% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WtCoxG.R
\name{GRAB.WtCoxG}
\alias{GRAB.WtCoxG}
\title{WtCoxG method in GRAB package}
\usage{
GRAB.WtCoxG()
}
\value{
No return value, called for side effects (prints information about the WtCoxG method to the console).
}
\description{
WtCoxG is an accurate, powerful, and computationally efficient Cox-based approach to perform genome-wide time-to-event data analyses in study cohorts with case ascertainment.
}
\details{
Additional arguments in \code{GRAB.NullModel()}:
\itemize{
\item \code{RefAfFile}: A character string specifying a reference allele frequency file, which is a csv file (with a header) and includes columns of \code{CHROM}, \code{POS}, \code{ID}, \code{REF}, \code{ALT}, \code{AF_ref}, and \code{AN_ref}.
\item \code{OutputFile}: A character string specifying the output file name.
\item \code{SampleIDColumn}: A character string specifying the column name in the input data that contains sample IDs.
\item \code{SurvTimeColumn}: A character string specifying the column name in the input data that contains survival time information.
\item \code{IndicatorColumn}: A character string specifying the column name in the input data that indicates case-control status (should be 0 for controls and 1 for cases).
}

Additional arguments in list \code{control} in \code{GRAB.NullModel()}:
\itemize{
\item \code{RefPrevalence}: A numeric value specifying the population-level disease prevalence used for weighting in the analysis.
\item \code{SNPnum}: Minimum number of SNPs. Default is 1e4.
}

Additional arguments in list \code{control} in \code{GRAB.Marker()}:
\itemize{
\item \code{cutoff}: A numeric value specifying the batch effect p-value cutoff for method selection of an association test. Default is 0.1.
}
}
\examples{
# Step0&1: fit a null model and estimate parameters according to batch effect p-values
PhenoFile <- system.file("extdata", "simuPHENO.txt", package = "GRAB")
PhenoData <- data.table::fread(PhenoFile, header = TRUE)
SparseGRMFile <- system.file("extdata", "SparseGRM.txt", package = "GRAB")

GenoFile <- system.file("extdata", "simuPLINK.bed", package = "GRAB")
RefAfFile <- system.file("extdata", "simuRefAf.txt", package = "GRAB")
RefPrevalence <- 0.1 # population-level disease prevalence

OutputDir <- tempdir()
OutputStep1 <- file.path(OutputDir, "WtCoxG_step1_out.txt")
OutputStep2 <- file.path(OutputDir, "WtCoxG_step2_out.txt")

obj.WtCoxG <- GRAB.NullModel(
  formula = survival::Surv(SurvTime, SurvEvent) ~ AGE + GENDER,
  data = PhenoData,
  subjData = PhenoData$IID,
  method = "WtCoxG",
  traitType = "time-to-event",
  GenoFile = GenoFile,
  SparseGRMFile = SparseGRMFile,
  control = list(
    AlleleOrder = "ref-first", 
    AllMarkers = TRUE, 
    RefPrevalence = RefPrevalence,
    SNPnum = 1000  # the minimum number of SNPs that TestforBatchEffect() needs
  ), 
  RefAfFile = RefAfFile,
  OutputFile = OutputStep1,
  SampleIDColumn = "IID",
  SurvTimeColumn = "SurvTime",
  IndicatorColumn = "SurvEvent"
)

resultStep1 <- data.table::fread(OutputStep1)
resultStep1[, c("CHROM", "POS", "pvalue_bat")]

# Step2: conduct association testing
GRAB.Marker(
  objNull = obj.WtCoxG,
  GenoFile = GenoFile,
  OutputFile = OutputStep2,
  control = list(
    AlleleOrder = "ref-first", 
    AllMarkers = TRUE,
    cutoff = 0.1, 
    nMarkersEachChunk = 5000
  )
)

resultStep2 <- data.table::fread(OutputStep2)
resultStep2[, c("CHROM", "POS", "WtCoxG.noext", "WtCoxG.ext")]

}
