% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DenseGRM.R
\name{getDenseGRM}
\alias{getDenseGRM}
\title{Suppose that a dense GRM is Phi and input is bVec, return Phi * bVec (only for developers)}
\usage{
getDenseGRM(bVec)
}
\arguments{
\item{bVec}{a numeric vector with the same length as in subjData (check the input of \code{setDenseGRM})}
}
\value{
a numeric vector of Phi * bVec
}
\description{
Suppose that a dense GRM is Phi and input is bVec, return Phi * bVec (only for developers), users can simply ignore this function
}
\examples{
# set up the dense GRM in C++
GenoFile <- system.file("extdata", "simuPLINK.bed", package = "GRAB")
famData <- read.table(gsub("bed", "fam", GenoFile))
subjData <- famData$V2
genoList <- setDenseGRM(GenoFile, subjData = subjData)

set.seed(1)
bVec <- rnorm(1000)
KinbVec <- getDenseGRM(bVec)

# The following is based on the definition of GRM to validate the DenseGRM object
PlinkFile <- system.file("extdata", "simuPLINK.bed", package = "GRAB")
IDsToIncludeFile <- system.file("extdata", "simuGENO.IDsToInclude", package = "GRAB")
GenoList <- GRAB.ReadGeno(PlinkFile, control = list(IDsToExcludeFile = IDsToIncludeFile))
GenoMat <- GenoList$GenoMat
markerInfo <- GenoList$markerInfo
pos <- which(markerInfo$CHROM != 1)
GenoMat <- GenoMat[, pos]
MAF <- apply(GenoMat, 2, mean) / 2
stdGenoMat <- (t(GenoMat) - 2 * MAF) / sqrt(2 * MAF * (1 - MAF)) / sqrt(ncol(GenoMat))
KinMat <- t(stdGenoMat) \%*\% stdGenoMat
KinbVec1 <- KinMat \%*\% bVec
# plot(KinbVec, KinbVec1)
head(cbind(KinbVec, KinbVec1))

}
