% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_index.R
\name{build_index}
\alias{build_index}
\title{Build index for mapping using Salmon}
\usage{
build_index(species = c("human", "mouse", "rat"), kmer = 31,
  ens_release = 92, destdir)
}
\arguments{
\item{species}{name of the species. Only \code{'human'}, \code{'mouse'}, 
and \code{'rat'} are allowed to use.}

\item{kmer}{k-mer size for indexing. default is 31. See \code{'Salmon'} 
for details.}

\item{ens_release}{version of Ensembl release.}

\item{destdir}{directory where all the files will be saved.}
}
\value{
directory of index files
}
\description{
\code{build_index} for mapping reads using Salmon.
}
\examples{

#Running this function will take some time.
\donttest{
build_index(species="human",kmer=31,
ens_release=92,destdir=tempdir())
}

}
\references{
Rob Patro, Geet Duggal, Michael I. Love, Rafael A. Irizarry, and 
Carl Kingsford (2017): Salmon provides fast and bias-aware 
\url{https://www.nature.com/articles/nmeth.4197}
}
