% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_docs.R
\docType{data}
\name{GROAN.KI}
\alias{GROAN.KI}
\title{Example data for pea KI lines}
\format{
A list with the following fields:
\itemize{
 \item{\emph{"GROAN.KI$yield"}}: named array with 103 slots, containing data on grain yield [t/ha]
 \item{\emph{"GROAN.KI$SNPs"}}: data frame with 103 rows and 647 variables. Each row is
 a pea KI line, each column a SNP marker. Values can either be 0, 1, or 2,
representing the three possible genotypes (AA, Aa, and aa, respectively).
 \item{\emph{"GROAN.KI$kinship"}}: square dataframe containing the realized kinships between
all pairs of each of the 103 pea KI lines. Values were computed following the
\href{https://www.jstor.org/stable/25681325}{Astle & Balding metric}.
Higher values represent a higher degree of genetic similarity between
lines. This metric mainly accounts for additive genetic contributions
(as an alternative to dominant contributions).
}
}
\source{
Annicchiarico et al., \emph{GBS-Based Genomic Selection
for Pea Grain Yield under Severe Terminal Drought}, The Plant Genome,
Volume 10. \doi{doi:10.3835/plantgenome2016.07.0072}
}
\usage{
GROAN.KI
}
\description{
This list contains all data required to run GROAN examples. It refers to a pea experiment
with 103 lines coming from a biparental Kaspa x Isard cross.
}
\keyword{datasets}
