% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Denoise.R
\name{denoise}
\alias{denoise}
\title{Use a given dictionary D to denoise image.}
\usage{
denoise(Y, D, sigma)
}
\arguments{
\item{Y}{Each column of Y is a vectorized image patch to be denoised.}

\item{D}{D is the dictionary used in Y=DA to denoise.}

\item{sigma}{Noise level.}
}
\value{
The denoised matrix Y.
}
\description{
Denoise Y give D in Y=DA.
}
\details{
See \url{https://arxiv.org/abs/1605.07870}
}
\examples{
I = lena_crop #use a smaller image as an example
## add noise
sigma=20;
I_noise=AddNoise(I,sigma)
## spliting image into patches
m=64;
Y_nc = ImageSplit(I_noise,sqrt(m),sqrt(m));
mu=colMeans(Y_nc)
Y=Y_nc-rep(mu,each=nrow(Y_nc))
## use ODCT dictionary
D0=ODCT(64,100)
## denoise
\dontrun{
Y_denoise=denoise(Y,D0,sigma)
}
}
