% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selection.R, R/unselection.R
\name{selection}
\alias{selection}
\alias{unselection}
\title{Select Subsets of GTFS Data}
\usage{
selection(gtfs, ..., add = FALSE)

unselection(gtfs)
}
\arguments{
\item{gtfs}{An object representing GTFS data. It can be a list or a `wizardgtfs` class gtfsect.}

\item{...}{Expressions used to filter the data within `gtfs`. The expressions can operate on four GTFS variables:
  \describe{
    \item{\code{"stop_id"}}{Select the GTFS by stops using a vector of stop_id, must be character.}
    \item{\code{"route_id"}}{Select the GTFS by routes using a vector of route_id, must be character.}
    \item{\code{"trip_id"}}{Select the GTFS by trip using a vector of trip_id, must be character.}
    \item{\code{"geometry"}}{Select the GTFS by stops using an `sf`, `sfc`, or `sfg` object. The geometry predicate function is evaluated with the geometry of the GTFS stops. Available predicates are:

             \code{\%intersects\%}

             \code{\%touches\%}

             \code{\%within\%}

             \code{\%equals\%}

             \code{\%overlaps\%}

             \code{\%contains\%}.}
  }}

\item{add}{A logical argument. If `TRUE`, appends the new selection to existing ones in the gtfsect; otherwise, creates a new selection.}
}
\value{
A `wizardgtfs_selected` wizardgtfs, which is a modified version of the original attributes with the selections applied. If the expression yields no matches, returns the original gtfs unchanged.
}
\description{
The “selection” function makes a selection in the GTFS file without altering or filtering the GTFS file.
}
\details{
The function evaluates the provided expressions in an environment restricted to recognized variables (`stop_id`, `route_id`, `trip_id`, `geometry`). An error is thrown if an unrecognized variable is used, indicating that only specific variables are allowed.
}
\examples{
# Apply the selection function
result <- selection(for_rail_gtfs,
 stop_id == for_rail_gtfs$stops$stop_id[1] & trip_id \%in\% for_rail_gtfs$trips$trip_id[1:5])

# Check the selection
class(result)
attr(result, 'selection')

# Use geometry selection
bbox <- sf::st_bbox(c(
  xmin = -38.57219059002416,
  ymin = -3.7999496173114118,
  xmax = -38.50455165901261,
  ymax = -3.756631724636505
),
crs = sf::st_crs(4326))  # Set CRS to WGS 84

# Convert the bounding box to a polygon
polygon <- sf::st_as_sfc(bbox)

result <- for_rail_gtfs |> selection(geometry \%intersects\% polygon)

}
