% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/my_gems.R
\name{generateParameterCovarianceMatrix}
\alias{generateParameterCovarianceMatrix}
\title{generate a template for parameter covariances}
\usage{
generateParameterCovarianceMatrix(muM,
  statesNamesFrom = (dimnames(muM@list.matrix)["from"])[[1]],
  statesNamesTo = statesNamesFrom)
}
\arguments{
\item{muM}{a \code{transition.structure} of dimension \eqn{N \times N}{N x
N}, whose components \code{list} the mean values for the parameters in the
\code{transitionFunctions}.}

\item{statesNamesFrom}{a list of names of states in the model. By default list(State 1, State 2, ..., State N)}

\item{statesNamesTo}{a list of names of states in the model. By default list(State 1, State 2, ..., State N)}
}
\value{
a \code{transition.structure} of dimension \eqn{N \times N}{N x N}
of covariance matrices for the \code{parameters}.
}
\description{
This function simplifies generating the matrix of parameter covariances from
a matrix of mean parameters.
}
\seealso{
\code{\link{transition.structure}},
\code{\link{generateParameterMatrix}}, \code{\link{simulateCohort}}
}
\author{
Luisa Salazar Vizcaya, Nello Blaser, Thomas Gsponer
}
\keyword{utilities}
