#' Comprehensive and Easy to Use Quality Control of GWAS Results
#'
#' When evaluating the results of a genome-wide association study (GWAS), it is important to perform a quality control to ensure that the results are valid, complete, correctly formatted, and, in case of meta-analysis, consistent with other studies in the same analysis.
#' This package was developed to facilitate and streamline this process and provide the user with a comprehensive report.
#'
#' Check out our website for more help and support  \url{http://GWASinspector.com}.
#'
#' @note
#' GWASinspector uses the S4 object system of R to conduct the QC.
#' The QC is configured using an configuration (ini) file (check \code{\link{get.config}}), which is imported into R through \code{\link{setup.inspector}} and
#' turns into an object of the \linkS4class{Inspector} class. To perform the QC, process the object with \code{\link{run.inspector}}.
#' A quick scan of the results can be performed via \code{\link{result.inspector}}, but the primary outcome of the QC are the
#' report files and graphs generated by \code{\link{run.inspector}}.
#'
#' The main product of the QC is the extensive log file (in Excel/HTML format, depending on your settings)
#'
#' @section Functions:
#'
#' \code{\link{setup.inspector}} This function Imports a QC-configuration file into R by generating a new instance of \linkS4class{Inspector} class.
#'
#' \code{\link{run.inspector}} This is the main function for running the algorithm on a set of GWAS result files.
#'
#' \code{\link{result.inspector}} This function displays a brief report about the results of running the Inspector algorithm on a set of GWAS result files.
#'
#' \code{\link{demo.inspector}} This function runs the algorithm on a fabricated GWAS result file. User should only set the output folder for saving the generated files. The input file and reference dataset are embedded in the package.
#'
#' \code{\link{system.check}} Checks if required and optional packages are installed on the system. Although the optional packages do not contribute to the QC itself, having them available will allow for Excel and HTML formatted report files, which are easier to read and interpret.
#'
#' \code{\link{get.config}} Copies the template configuration file to the local machine.
#'
#' \code{\link{get.headerTranslation}} Copies the template configuration file to the local machine.
#'
#' \code{\link{compare.GWASs}} Generates reports and plots for comparing the summary statistics of GWAS result files that are previously inspected with this package.
#'
#' \code{\link{manhattan.plot}} Generates the Manhattan plot from a GWAS result file. This function has many features that are described in the package tutorial.
#'
#'
#' @docType package
#' @name GWASinspector
NULL
