% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PrimaryRemoveWg.R
\name{PrimaryRemoveWg}
\alias{PrimaryRemoveWg}
\alias{CandidatesNumWg}
\alias{ForcedWg}
\title{Special functions for the avoidance of suppression}
\usage{
PrimaryRemoveWg(wg = NULL, ..., crossTable)

CandidatesNumWg(wg = NULL, ..., crossTable)

ForcedWg(crossTable, wg = NULL, ...)
}
\arguments{
\item{wg}{data.frame with wildcard/globbing.
A parameter to \code{\link{WildcardGlobbing}}}

\item{...}{unused parameters}

\item{crossTable}{crossTable generated by parent function}
}
\value{
logical vector or row indices
}
\description{
The SSBtools function \code{\link{WildcardGlobbing}} is utilized
}
\details{
\code{CandidatesNumWg} is a generalization of \code{\link{CandidatesNumWg}}
}
\examples{
dataset <- SSBtoolsData("magnitude1")

a1 <- SuppressDominantCells(data = dataset, numVar = "value", 
       dimVar = c("sector4", "geo"), n = 1:2, k = c(77, 99))

a1

wg <- data.frame(sector4 = "Ind*", geo = c("Ice????", "Portugal"))
wg

# Industry:Portugal not primary, but suppressed
a2 <- SuppressDominantCells(data = dataset, numVar = "value", 
       dimVar = c("sector4", "geo"), n = 1:2, k = c(77, 99), 
       wg = wg, primary = c(DominanceRule, PrimaryRemoveWg))

a2

# Industry:Portugal not primary and not suppressed
a3 <- SuppressDominantCells(data = dataset, numVar = "value", 
       dimVar = c("sector4", "geo"), n = 1:2, k = c(77, 99), 
       wg = wg, primary = c(DominanceRule, PrimaryRemoveWg), 
       candidates = CandidatesNumWg)
a3

# Industry:Portugal primary, but not suppressed
a4 <- SuppressDominantCells(data = dataset, numVar = "value", 
       dimVar = c("sector4", "geo"), n = 1:2, k = c(77, 99), 
       wg = wg, forced = ForcedWg, whenPrimaryForced = message)
a4
}
