% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BivariateFitter.R
\name{BivariateFitters}
\alias{BivariateFitters}
\alias{BivariateFitter}
\alias{GenBivariateFitter}
\title{Fitter function for GeD Spline Regression for bivariate data}
\usage{
BivariateFitter(
  X,
  Y,
  Z,
  W,
  weights = rep(1, length(X)),
  Indicator,
  beta = 0.5,
  phi = 0.99,
  min.intknots = 0,
  max.intknots = 300,
  q = 2,
  Xextr = range(X),
  Yextr = range(Y),
  show.iters = TRUE,
  tol = as.double(1e-12),
  stoptype = c("SR", "RD", "LR")
)

GenBivariateFitter(
  X,
  Y,
  Z,
  W,
  family = family,
  weights = rep(1, length(X)),
  Indicator,
  beta = 0.5,
  phi = 0.5,
  min.intknots = 0,
  max.intknots = 300,
  q = 2,
  Xextr = range(X),
  Yextr = range(Y),
  show.iters = TRUE,
  tol = as.double(1e-12),
  stoptype = c("SR", "RD", "LR")
)
}
\arguments{
\item{X}{a numeric vector containing \eqn{N} sample values of the first
independent variable chosen to enter the spline regression component of the
predictor model.}

\item{Y}{a numeric vector containing \eqn{N} sample values of the second
independent variable chosen to enter the spline regression component of the
predictor model.}

\item{Z}{a vector of size \eqn{N} containing the observed values of the
response variable.}

\item{W}{a design matrix with \eqn{N} rows containing other covariates
selected to enter the parametric component of the predictor model (see
\code{\link[=formula.GeDS]{formula}}). If no such covariates are selected, it
is set to \code{NULL} by default.}

\item{weights}{an optional vector of size \eqn{N} of `prior weights' to be
put on the observations in the fitting process in case the user requires
weighted GeDS fitting. It is \code{NULL} by default.}

\item{Indicator}{contingency table of \code{X} and \code{Y}.}

\item{beta}{numeric parameter in the interval \eqn{[0,1]} tuning the knot
placement in stage A of GeDS. See the description of \code{\link{NGeDS}} or
\code{\link{GGeDS}}.}

\item{phi}{numeric parameter in the interval \eqn{[0,1]} specifying the
threshold for the stopping rule  (model selector) in stage A of GeDS. See
also \code{stoptype} and details in the description of \code{\link{NGeDS}} or
\code{\link{GGeDS}}.}

\item{min.intknots}{optional parameter allowing the user to set a minimum
number of internal knots required. By default equal to zero.}

\item{max.intknots}{optional parameter allowing the user to set a maximum
number of internal knots to be added by the GeDS estimation algorithm. By
default equal to the number of internal knots \eqn{\kappa} for the saturated
GeDS model (i.e. \eqn{\kappa=N-2}).}

\item{q}{numeric parameter which allows to fine-tune the stopping rule of
stage A of GeDS, by default equal to 2. See details in the description of
\code{\link{NGeDS}} or \code{\link{GGeDS}}.}

\item{Xextr}{boundary knots in the \code{X} direction. By default equal to
the range of \code{X}.}

\item{Yextr}{boundary knots in the \code{Y} direction. By default equal to
the range of \code{Y}.}

\item{show.iters}{logical variable indicating whether or not to print 
information at each step. By default equal to \code{FALSE}.}

\item{tol}{numeric value indicating the tolerance to be used in checking
whether two knots should be considered different during the knot placement
steps in stage A.}

\item{stoptype}{a character string indicating the type of GeDS stopping rule
to be used. It should be either \code{"SR"}, \code{"RD"} or \code{"LR"},
partial match allowed. See details of \code{\link{NGeDS}} or
\code{\link{GGeDS}}.}

\item{family}{a description of the error distribution and link function to be
used in the model. This can be a character string naming a family function
(e.g. \code{"gaussian"}), the family function itself (e.g.
\code{\link[stats]{gaussian}}) or the result of a call to a family function
(e.g. \code{gaussian()}). See \link[stats]{family} for details on family
functions.}
}
\value{
A \code{\link{GeDS-Class}} object, but without the \code{Formula},
\code{extcall}, \code{terms} and \code{znames} slots.
}
\description{
These are computing engines called by \code{\link{NGeDS}}, needed for the
underlying fitting procedures.
}
\references{
Dimitrova, D. S., Kaishev, V. K., Lattuada, A. and Verrall, R. J.  (2023).
Geometrically designed variable knot splines in generalized (non-)linear
models.
\emph{Applied Mathematics and Computation}, \strong{436}. \cr
DOI: \doi{10.1016/j.amc.2022.127493}
}
\seealso{
\code{\link{NGeDS}} and \code{\link{UnivariateFitters}}.
}
