% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/txt.fix.grammar.R
\name{txt.fix.grammar}
\alias{txt.fix.grammar}
\title{Generate correct text using the Generative AI model based on a prompt}
\usage{
txt.fix.grammar(model.parameter, temperature, prompt)
}
\arguments{
\item{model.parameter}{A character vector containing the Generative AI service provider,
corresponding model, version, API key, and proxy status.}

\item{temperature}{A numeric value. A higher value results in more creative responses,
while a lower value produces more straightforward text.}

\item{prompt}{A character string representing the query for text generation.}
}
\value{
If successful, a character string (correct text) generated by the Generative AI
model based on the provided query and parameters. If the API response indicates an error,
the function halts execution and provides an error message.
}
\description{
This function establishes a connection to a Generative AI model by providing essential
parameters and generates correct text based on the prompt.
}
\details{
Providing accurate and valid information for each parameter is crucial
to ensure successful text generation by the Generative AI model. If any of the
provided parameters is incorrect, the function will respond with an error message based
on the information received from the API. Use the function \code{\link{available.models}} to
see all supported Generative AI models.

A complete prompt behind the function is as follows:

Rewrite the following text and fix any grammar issues:

# Text starts #

\code{prompt}

# Text ends #
}
\examples{
\dontrun{
 # Get available models
 models = available.models()

 # Connect to the model, replace API_KEY with your api key
 google.model = connect.genai("google",
                              models$google$model[1],
                              models$google$version[1],
                              "API_KEY",
                              FALSE)

 # Connect to the model, replace API_KEY with your api key
 openai.model = connect.genai("openai",
                              models$openai$model[1],
                              models$openai$version[1],
                              "API_KEY",
                              FALSE)
 # Generate text
 temperature = 0.9
 prompt = "Yesterday, I will buy a book for my younger sister as his birthday gift.
           They were very happen when seeing this gift earlier today."
 correct.text = txt.fix.grammar(google.model,
                                temperature,
                                prompt)
 cat(correct.text)

 correct.text = txt.fix.grammar(openai.model,
                                temperature,
                                prompt)
 cat(correct.text)
}

}
\seealso{
\href{https://genai.gd.edu.kg/r/documentation/}{GenAI - R Documentation}
}
