% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splits_figure_functions.R
\name{plot.splitSummary}
\alias{plot.splitSummary}
\title{Plot summary statistics for splits of mortality estimates}
\usage{
\method{plot}{splitSummary}(x, rate = FALSE, ...)
}
\arguments{
\item{x}{A \code{splitSummary} object (result of \code{\link{calcSplits}})
that includes summary statistics for simulated mortality estimates for all
combinations of levels of 1 or 2 splitting covariates.}

\item{rate}{\code{logical} scalar indicating whether the figures should be
plotted as number of fatalities per split category (\code{rate = TRUE}) or
fatality rates per unit time (\code{rate = TRUE}). If the splits do not
include either a \code{split_SS} or \code{split_time} variable, the
\code{rate} arg is ignored.}

\item{...}{additional arguments to be passed down}
}
\description{
The S3 \code{plot} method for \code{splitSummary} objects 
  constructs boxplots of the mortality estimates for all combinations of 
  splitting covariates summarized in the \code{splits} variable.

For 1-covariate splits, box plots showing median, IQR, and confidence
  intervals (for the \code{CL} attribute for the splits object). For
  2-covariate splits, the box plots are in an array with levels of
  the temporal split (\code{split_SS} or \code{split_time}) arranged
  horizontally (if present) and the levels of the \code{split_CO} variable
  arranged vertically. If no temporal splits are present, then the box 
  plots along the levels of the first \code{split_CO} variable are arranged
  horizontally and the levels of the second variable are are arranged
  vertically.
}
