% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ForecastHMMCdf.R
\name{ForecastHMMCdf}
\alias{ForecastHMMCdf}
\title{Forecasted cumulative distribution function of a univariate HMM at times n+k1, n+k2,....}
\usage{
ForecastHMMCdf(y, family, theta, Q, eta, k = 1, graph = 0)
}
\arguments{
\item{y}{points at which the cdf function is comptuted}

\item{family}{distribution name; run the function distributions() for help}

\item{theta}{parameters; (r  x p)}

\item{Q}{probability transition  matrix; (r  x r)}

\item{eta}{vector of the estimated probability of each regime at time n; (1 x r)}

\item{k}{times of prediction.}

\item{graph}{(0 or else) produce plots}
}
\value{
\item{cdf}{values of the cdf function}
}
\description{
This function computes the forecasted cumulative distribution function of a univariate HMM for multiple horizons, given observations up to time n
}
\examples{
family = "gaussian"
lb = -6
ub = 6


theta = matrix(c(-1.5, 1.7, 1, 1),2,2)
Q = matrix(c(0.8, 0.3, 0.2, 0.7), 2, 2)
eta = c(0.96091218, 0.03908782)

forecastedhmmcdf = ForecastHMMCdf(y=seq(from=-6, to=6, by=0.1), family=family,
theta= theta, Q=Q, eta=eta, k=c(1,5,10,20), graph=1)


}
