% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{plotMetaPrograms}
\alias{plotMetaPrograms}
\title{Visualizations for meta-programs}
\usage{
plotMetaPrograms(
  mp.res,
  similarity.cutoff = c(0, 1),
  scale = "none",
  palette = viridis(100, option = "A", direction = -1),
  annotation_colors = NULL,
  main = "Clustered Heatmap",
  show_rownames = FALSE,
  show_colnames = FALSE,
  ...
)
}
\arguments{
\item{mp.res}{The meta-programs object generated by \code{\link{getMetaPrograms}}}

\item{similarity.cutoff}{Min and max values for similarity metric}

\item{scale}{Heatmap rescaling (passed to pheatmap as 'scale')}

\item{palette}{Heatmap color palette (passed to pheatmap as 'color')}

\item{annotation_colors}{Color palette for MP annotations}

\item{main}{Heatmap title}

\item{show_rownames}{Whether to display individual program names as rows}

\item{show_colnames}{Whether to display individual program names as cols}

\item{...}{Additional parameters for pheatmap}
}
\value{
Returns a clustered heatmap of MP similarities, in ggplot2 format
}
\description{
Generates a clustered heatmap for meta-program similarities (by Jaccard 
index or Cosine similarity). This function is intended to be run on the object
generated by \code{\link[GeneNMF]{getMetaPrograms}}, which contains a pre-calculated 
tree of pairwise similarities between clusters (as a 'hclust' object).
}
\examples{
library(Seurat)
data(sampleObj)
geneNMF_programs <- multiNMF(list(sampleObj), k=5)
geneNMF_metaprograms <- getMetaPrograms(geneNMF_programs, nMP=3)
plotMetaPrograms(geneNMF_metaprograms)

}
