% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/GeoLight.R
\name{coord}
\alias{coord}
\title{Simple Threshold Geolocation Estimates}
\usage{
coord(tFirst, tSecond, type, twl, degElevation = -6, tol = 0,
  method = "NOAA", note = TRUE)
}
\arguments{
\item{tFirst}{vector of sunrise/sunset times (e.g. 2008-12-01 08:30).}

\item{tSecond}{vector of of sunrise/sunset times (e.g. 2008-12-01 17:30).}

\item{type}{vector of either 1 or 2, defining \code{tFirst} as sunrise or sunset respectively.}

\item{twl}{data.frame containing twilights and at least \code{tFirst}, \code{tSecond} and \code{type} (alternatively give each parameter separately).}

\item{degElevation}{the sun elevation angle (in degrees) that defines twilight (e.g. -6 for "civil
twilight"). Either a single value, a \code{vector} with the same length as
\code{tFirst} or \code{nrow(x)}.}

\item{tol}{tolerance on the sine of the solar declination (only implemented in method 'NOAA').}

\item{method}{Defines the method for the location estimates. 'NOAA' is based on
code and the excel spreadsheet from the NOAA site (http://www.esrl.noaa.gov/gmd/grad/solcalc/),
'Montenbruck' is based on Montenbruck, O. & Pfleger, T. (2000) Astronomy on the Personal
Computer. \emph{Springer}, Berlin.}

\item{note}{\code{logical}, if TRUE a notation of how many positions could
be calculated in proportion to the number of failures will be printed at the
end.}
}
\value{
A matrix of coordinates in decimal degrees. First column are
longitudes, expressed in degrees east of Greenwich. Second column contains
the latitudes in degrees north the equator.
}
\description{
Estimate location from consecutive twilights
}
\details{
This function estimates the location given the times at which
the observer sees two successive twilights.

Longitude is estimated by computing apparent time of local noon
from sunrise and sunset, and determining the longitude for which
this is noon. Latitude is estimated from the required zenith and
the sun's hour angle for both sunrise and sunset, and averaged.

When the solar declination is near zero (at the equinoxes)
latitude estimates are extremely sensitive to errors.  Where the
sine of the solar declination is less than \code{tol}, the
latitude estimates are returned as \code{NA}.

The format (date and time) of \emph{tFirst} and \emph{tSecond} has to be
"yyyy-mm-dd hh:mm" corresponding to Universal Time Zone UTC (see:
\code{\link{as.POSIXct}}, \link[=Sys.timezone]{time zones})
}
\examples{
data(hoopoe2)
  hoopoe2$tFirst <- as.POSIXct(hoopoe2$tFirst, tz = "GMT")
  hoopoe2$tSecond <- as.POSIXct(hoopoe2$tSecond, tz = "GMT")
crds <- coord(hoopoe2, degElevation=-6, tol = 0.2)
## tripMap(crds, xlim=c(-20,20), ylim=c(5,50), main="hoopoe2")
}
\author{
Simeon Lisovski, Simon Wotherspoon, Michael Sumner
}

