% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/efficiency.R
\name{are_nr}
\alias{are_nr}
\title{Newton-Raphson method for the \code{are} function}
\usage{
are_nr(estimator, k, startingpoint, level = 0.95)
}
\arguments{
\item{estimator}{M-type estimator (\code{'huber'} or \code{'tukey'}).}

\item{k}{Dimension of the manifold.}

\item{startingpoint}{Initial estimate for the Newton-Raphson method. May be
determined after looking at a graph of the \code{are} function.}

\item{level}{The desired ARE to the \code{'l2'} estimator.}
}
\value{
Positive multiplier of \eqn{\sigma}, the square root of the variance,
  used in the cutoff parameter, to give the desired level of efficiency.
}
\description{
Finds the positive multiplier of \eqn{\sigma}, the square root of the
variance, used in the cutoff parameter that will give the desired
(approximate) level of efficiency for the provided M-type estimator. Does so
by using \code{are} and its partial derivative with respect to \code{c} in
the Newton-Raphson method.
}
\details{
As is often the case with the Newton-Raphson method, the starting point must
be chosen carefully in order to ensure convergence. The use of the graph of
the \code{are} function to find a starting point close to the root is
recommended.
}
\examples{
dimension <- 4
x <- 1:10000 / 1000
# use a graph of the are function to pick a good starting point
plot(x, are('huber', dimension, x) - 0.95)
are_nr('huber', dimension, 2)

}
\references{
Shin, H.-Y. and Oh H.-S. (2020). Robust Geodesic Regression. <arXiv:2007.04518>
}
\seealso{
\code{\link{are}}.
}
\author{
Ha-Young Shin
}
