% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TO_TM.R
\name{TO_TM}
\alias{TO_TM}
\title{To convert from Geographic coordinate to TM.}
\usage{
TO_TM(a = 47, longlat_df, d, e, f, g, digits = 4)
}
\arguments{
\item{a}{Selection of Ellipsoid.}

\item{longlat_df}{Sexagesimal longitude and latitude as dataframe.}

\item{d}{Central meridian.}

\item{e}{Scale factor Ko.}

\item{f}{False East (FE).}

\item{g}{False North (FN).}

\item{digits}{Number of digits the seconds are \code{\link{round}ed} to. DEFAULT: 4}
}
\value{
data.frame with the data in the following order: "East", "North", "X", "Y".
}
\description{
With this function it is possible to convert from Geographic coordinate to TM using the Central meridian, Scale factor Ko, False East, False North and obtain the decimal precision that you assign.
}
\note{
create data frame of epsg codes by epsg <- rgdal::make_EPSG()
}
\examples{
# Test data
CM <- -69.00000
SC_FACTOR_Ko <- 0.99960
FE <- 500000.00000
FN <- 10000000.00000

# Point name
Pto <- "St1"

# Longitude
g <- -71
m <- 18
s <- 44.86475

# Value in sexagesimal
sexa_long <- sexagesimal(g, m, s)

# Latitude
g1 <- -33
m1 <- 12
s1 <- 27.11457

# Value in sexagesimal
sexa_lat <- sexagesimal(g1, m1, s1)

# Longitude and Latitude as data.frame
longlat_df <- as.data.frame(cbind(Pto,sexa_long,sexa_lat))

# ELLIPSOIDAL HEIGHT (h)
h <- 31.885

# To know the ellipsoids and the order open the Ellipsoids in the package and look for it number
Ellip <- Ellipsoids
#View(Ellip)

# We choose the number 47 which is WGS84
value <- TO_TM(a = 47, longlat_df, CM, SC_FACTOR_Ko, FE, FN, digits = 4)
print(value)
}
\references{
https://github.com/OSGeo/PROJ & https://github.com/cran/rgdal
}
