% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Cartesian.R
\name{cartesian}
\alias{cartesian}
\title{To convert from Geographic coordinate to Cartesian coordinate.}
\usage{
cartesian(a, longlat_df, digits = 4)
}
\arguments{
\item{a}{Selection of Ellipsoid.}

\item{longlat_df}{Point name, Sexagesimal longitude and latitude as dataframe.}

\item{digits}{Number of digits the seconds are \code{\link{round}ed} to. DEFAULT: 4}
}
\value{
data.frame with the data in the following order: "Pt", "X", "Y", "Z".
}
\description{
With this function it is possible to convert from Geographic coordinate to Cartesian coordinate and obtain the decimal precision that you assign.
}
\note{
create data frame of epsg codes by epsg <- rgdal::make_EPSG()
}
\examples{
# Point name
Pto <- "St1"

# Longitude
g <- -71
m <- 18
s <- 44.86475

# Value in sexagesimal
sexa_long <- sexagesimal(g,m,s)

# Latitude
g <- -33
m <- 38
s <- 30.123456

# Value in sexagesimal
sexa_lat <- sexagesimal(g, m, s)
print(sexa_lat)

# ELLIPSOIDAL HEIGHT (h)
h <- 31.885

# Longitude and Latitude as data.frame
longlat_df <- data.frame(Pto, sexa_long, sexa_lat, h)

# To know the ellipsoids and the order open the Ellipsoids in the package and look for it number
Ellip <- Ellipsoids
#View(Ellip)

# We choose the number 5 which is GRS80
value <- cartesian(5, longlat_df, digits = 4)
print(value)
}
\references{
https://github.com/OSGeo/PROJ & https://github.com/cran/rgdal
}
