% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gitstats_functions.R
\name{get_R_package_usage}
\alias{get_R_package_usage}
\title{Get data on package usage across repositories}
\usage{
get_R_package_usage(
  gitstats_object,
  packages,
  only_loading = FALSE,
  split_output = FALSE,
  cache = TRUE,
  verbose = is_verbose(gitstats_object)
)
}
\arguments{
\item{gitstats_object}{A GitStats object.}

\item{packages}{A character vector, names of R packages to look for.}

\item{only_loading}{A boolean, if \code{TRUE} function will check only if package
is loaded in repositories, not used as dependencies.}

\item{split_output}{Optional, a boolean. If \code{TRUE} will return a list of
tables, where every element of the list stands for the package passed to
\code{packages} parameter. If \code{FALSE}, will return only one table with name of
the package stored in first column.}

\item{cache}{A logical, if set to \code{TRUE} GitStats will retrieve the last
result from its storage.}

\item{verbose}{A logical, \code{TRUE} by default. If \code{FALSE} messages and printing
output is switched off.}
}
\value{
A \code{tibble} or \code{list} of \code{tibbles} depending on \code{split_output}
parameter.
}
\description{
Wrapper over searching repositories by code blobs related to
loading package (\code{library(package)} and \code{require(package)} in all files) or
using it as a dependency (\code{package} in \code{DESCRIPTION} and \code{NAMESPACE}
files).
}
\examples{
\dontrun{
 my_gitstats <- create_gitstats() \%>\%
  set_github_host(
    token = Sys.getenv("GITHUB_PAT"),
    orgs = c("r-world-devs", "openpharma")
  )

 get_R_package_usage(
   gitstats_object = my_gitstats,
   packages = c("purrr", "shiny"),
   split_output = TRUE
 )
}
}
