% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GWAS_binary.R
\name{GWAS_binary}
\alias{GWAS_binary}
\title{GWAS_binary function
This function performs GWAS using plink2 and outputs the GWAS summary statistics with additive SNP effects. Users may save the output in a user-specified file (see example).}
\usage{
GWAS_binary(plink_path, b_file, Bphe_discovery, Bcov_discovery, thread = 20)
}
\arguments{
\item{plink_path}{Path to the PLINK executable application}

\item{b_file}{Prefix of the binary files, where all .fam, .bed and .bim files have a common prefix}

\item{Bphe_discovery}{Name (with file extension) of the phenotype file containing family ID, individual ID and phenotype of the discovery dataset as columns, without heading}

\item{Bcov_discovery}{Name (with file extension) of the covariate file containing family ID, individual ID, standardized covariate, square of standardized covariate, and/or confounders of the discovery dataset as columns, without heading}

\item{thread}{Number of threads used}
}
\value{
This function will perform GWAS and output
\item{B_out.trd.sum}{GWAS summary statistics with additive SNP effects}
}
\description{
GWAS_binary function
This function performs GWAS using plink2 and outputs the GWAS summary statistics with additive SNP effects. Users may save the output in a user-specified file (see example).
}
\examples{
\dontrun{
x <- GWAS_binary(plink_path, DummyData, Bphe_discovery, Bcov_discovery, 
thread = 20)
sink("B_out.trd.sum") #to create a file in the working directory
write.table(x[c("ID", "A1", "OR")], sep = " ", 
row.names = FALSE, quote = FALSE) #to write the output
sink() #to save the output
head(x) #to obtain the head of GWAS summary statistics of additive SNP effects
x$CHROM #to extract the chromosome number 
x$POS #to extract the base pair position 
x$ID #to extract the SNP ID 
x$REF #to extract the reference allele 
x$ALT #to extract the alternate allele 
x$A1 #to extract the minor allele 
x$OBS_CT #to extract the number of allele observations 
x$OR #to extract the odds ratios of the SNP effects
x$LOG_OR_SE #to extract the standard errors of log odds 
x$Z_STAT #to extract the test statistics 
x$P #to extract the p values 
}
}
\keyword{gwas}
