% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_summary.R
\name{compare_var_structure}
\alias{compare_var_structure}
\title{Compare Variable Structures Across SL4 and HAR Objects}
\usage{
compare_var_structure(variables = NULL, ..., keep_unique = FALSE)
}
\arguments{
\item{variables}{Character vector. Variable names to compare. Use \code{NULL} or \code{"ALL"} to compare all variables.}

\item{...}{Named SL4 or HAR objects to compare.}

\item{keep_unique}{Logical. If \code{TRUE}, returns unique variable structures across datasets instead of checking for compatibility. Default is \code{FALSE}.}
}
\value{
A list containing:
\itemize{
\item \code{match}: A data frame listing variables with identical structures across datasets.
\item \code{diff}: A data frame listing variables with mismatched structures, useful for debugging and alignment.
\item If \code{keep_unique = TRUE}, instead of \code{match} and \code{diff}, returns a data frame with distinct variable structures across datasets.
}
}
\description{
Compares variable structures across multiple SL4 and HAR datasets to ensure compatibility.
Identifies matching and mismatched variable structures, helping users diagnose inconsistencies.
}
\details{
\itemize{
\item Verifies whether variables have consistent structures across multiple datasets.
\item Ensures correct ordering of dimensions and checks for structural compatibility.
\item If \code{keep_unique = TRUE}, returns a list of unique variable structures instead of performing a direct comparison.
\item Useful for merging or aligning datasets before further processing.
\item Helps detect differences in variable dimensions, which may arise due to model updates or dataset variations.
}
}
\examples{
# Import sample data:
har_data1 <- load_harx(system.file("extdata", "TAR10-WEL.har", package = "HARplus"))
har_data2 <- load_harx(system.file("extdata", "SUBT10-WEL.har", package = "HARplus"))

# Compare structure for a single variable across multiple datasets
compare_var_structure("A", har_data1, har_data2)

# Compare structure for multiple variables across multiple datasets
comparison_multiple <- compare_var_structure(c("A", "E1"), har_data1, har_data2)

# Extract unique variable structures across multiple datasets
unique_vars <- compare_var_structure("ALL", har_data1, har_data2, keep_unique = TRUE)

}
\seealso{
\code{\link{get_var_structure}}, \code{\link{get_dim_patterns}}, \code{\link{get_dim_elements}}
}
\author{
Pattawee Puangchit
}
