% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scan_fonc.R
\name{MPFSS}
\alias{MPFSS}
\title{MPFSS scan procedure}
\usage{
MPFSS(
  data,
  sites_coord = NULL,
  system = NULL,
  mini = 1,
  maxi = nrow(sites_coord)/2,
  type_minimaxi = "sites/indiv",
  mini_post = NULL,
  maxi_post = NULL,
  type_minimaxi_post = "sites/indiv",
  sites_areas = NULL,
  MC = 999,
  typeI = 0.05,
  method = c("LH", "W", "P", "R"),
  nbCPU = 1
)
}
\arguments{
\item{data}{list of numeric matrices. List of nb_sites (or nb_individuals if the observations are by individuals and not by sites) matrices of the data, the rows correspond to the variables and each column represents an observation time. The times must be equally spaced and the same for each site/individual.}

\item{sites_coord}{numeric matrix. Coordinates of the sites (or the individuals, in that case there can be many individuals with the same coordinates).}

\item{system}{character. System in which the coordinates are expressed: "Euclidean" or "WGS84".}

\item{mini}{numeric. A minimum for the clusters (see type_minimaxi). Changing the default value may bias the inference.}

\item{maxi}{numeric. A Maximum for the clusters (see type_minimaxi). Changing the default value may bias the inference.}

\item{type_minimaxi}{character. Type of minimum and maximum: by default "sites/indiv": the mini and maxi are on the number of sites or individuals in the potential clusters. Other possible values are "area": the minimum and maximum area of the clusters, or "radius": the minimum and maximum radius.}

\item{mini_post}{numeric. A minimum to filter the significant clusters a posteriori (see type_minimaxi_post). The default NULL is for no filtering with a a posteriori minimum.}

\item{maxi_post}{numeric. A maximum to filter the significant clusters a posteriori (see type_minimaxi_post). The default NULL is for no filtering with a a posteriori maximum.}

\item{type_minimaxi_post}{character. Type of minimum and maximum a posteriori: by default "sites/indiv": the mini_post and maxi_post are on the number of sites or individuals in the significant clusters. Other possible values are "area": the minimum and maximum area of the clusters, or "radius": the minimum and maximum radius.}

\item{sites_areas}{numeric vector. Areas of the sites. It must contain the same number of elements than the rows of sites_coord. If the data is on individuals and not on sites, there can be duplicated values. By default: NULL}

\item{MC}{numeric. Number of Monte-Carlo permutations to evaluate the statistical significance of the clusters. By default: 999.}

\item{typeI}{numeric. The desired type I error. A cluster will be evaluated as significant if its associated p-value is less than typeI. By default 0.05.}

\item{method}{character vector. The methods to compute the significant clusters. Options: "LH", "W", "P", "R" for respectively the Lawley-Hotelling trace test statistic, The Wilks lambda test statistic, the Pillai trace test statistic and the Roy's maximum root test statistic. By default all are computed.}

\item{nbCPU}{numeric. Number of CPU. If nbCPU > 1 parallelization is done. By default: 1.}
}
\value{
The list of the following elements according to the methods wanted:
\itemize{
\item sites_clusters_LH: the index of the sites (or individuals) included in the significant clusters for the LH method. The clusters are listed in their order of detection. The secondary clusters are defined according to Kulldorff.
\item pval_clusters_LH: the associated p-values
\item centres_clusters_LH: the coordinates of the centres of each cluster
\item radius_clusters_LH: the radius of the clusters in km if system = WGS84 or in the user units
\item areas_clusters_LH: the areas of the clusters (in the same units as sites_areas). Only if sites_areas is not NULL.
\item sites_clusters_W: the index of the sites (or individuals) included in the significant clusters for the W method. The clusters are listed in their order of detection. The secondary clusters are defined according to Kulldorff.
\item pval_clusters_W: the associated p-values
\item centres_clusters_W: the coordinates of the centres of each cluster
\item radius_clusters_W: the radius of the clusters in km if system = WGS84 or in the user units
\item areas_clusters_W: the areas of the clusters (in the same units as sites_areas). Only if sites_areas is not NULL.
\item sites_clusters_P: the index of the sites (or individuals) included in the significant clusters for the P method. The clusters are listed in their order of detection. The secondary clusters are defined according to Kulldorff.
\item pval_clusters_P: the associated p-values
\item centres_clusters_P: the coordinates of the centres of each cluster
\item radius_clusters_P: the radius of the clusters in km if system = WGS84 or in the user units
\item areas_clusters_P: the areas of the clusters (in the same units as sites_areas). Only if sites_areas is not NULL.
\item sites_clusters_R: the index of the sites (or individuals) included in the significant clusters for the R method. The clusters are listed in their order of detection. The secondary clusters are defined according to Kulldorff.
\item pval_clusters_R: the associated p-values
\item centres_clusters_R: the coordinates of the centres of each cluster
\item radius_clusters_R: the radius of the clusters in km if system = WGS84 or in the user units
\item areas_clusters_R: the areas of the clusters (in the same units as sites_areas). Only if sites_areas is not NULL.
\item system: the system of coordinates
}
}
\description{
This function returns the significant clusters and their associated p-value for the MPFSS.
}
\examples{
\donttest{
library(sp)
data("map_sites")
data("fmulti_data")
coords <- coordinates(map_sites)

res_mpfss <- MPFSS(data = fmulti_data, sites_coord = coords, system = "WGS84",
mini = 1, maxi = nrow(coords)/2)}
\dontshow{
library(sp)
data("map_sites")
data("fmulti_data")
indices <- which(map_sites$NAME_3 == "Lille")
coords <- coordinates(map_sites[indices,])
res_mpfss <- MPFSS(data = fmulti_data[indices], sites_coord = coords,
system = "WGS84", mini = 1, maxi = nrow(coords)/2, MC = 9)
}


}
