\name{HDDC}
\alias{hddc}
\title{
High Dimensional Data Clustering
}
\description{
HDDC is a model-based clustering method. It is based on the Gaussian Mixture Model and on the idea that the data lives in subspaces with a lower dimension than the dimension of the original space. It uses the Expectation - Maximisation algorithm to estimate the parameters of the model.
}
\usage{
hddc(data, k = 1:10, model = "AkjBkQkDk", threshold = 0.2, itermax = 60, eps = 0.01, graph = FALSE,
 algo = "EM", d = NULL, init = "kmeans", show = TRUE, mini.nb = c(5, 10), scaling = FALSE, ctrl = 1, cgraph = FALSE, ...)
}

\arguments{
  \item{data}{
A matrix or a data frame of observations, assuming the rows are the observations and the columns the variables. Note that NAs are not allowed.
}
  \item{k}{
A vector of integers specifying the number of clusters for which the BIC and the parameters are to be calculated ; the function keeps the parameters which maximises the BIC. Note that the length of the vector k can't be larger than 20. Default is 1:10.
}
  \item{model}{
A character string vector, or an integer vector indicating the models to be used. The available models are : "AkjBkQkDk", "AkBkQkDk", "ABkQkDk", "AkjBQkDk", "AkBQkDk", "ABQkDk", "AkjBkQkD", "AkBkQkD", "ABkQkD", "AkjBQkD", "AkBQkD", "ABQkD", "AjBQD", "ABQD". The default is model="AkjBkQkDk", the most general model. There are more details in \code{\link{hdda}}.
If several models are used, only the results of the one which maximizes the BIC criterion is kept. 
}
  \item{threshold}{
A float stricly within 0 and 1. It is the threshold used in the Cattel's Scree-Test.
}
  \item{itermax}{
The maximum number of iterations allowed. The default is 60.
}
  \item{eps}{
A positive double. It is the stop criterion : the algorithm stops when the difference between two successive Log Likelihoods are lower than eps.
}
  \item{graph}{
Logical. If TRUE, the evolution of the log-likelihood is plotted. Default is FALSE.
}
\item{cgraph}{
Logical. If TRUE, the results of the different clusterings are plotted. It gives the comparison of the results for different number of clusters and of different models.
}
  \item{algo}{
A character strings indicating the algorithm to be used. The available algorithms are the Expectation-Maximisation ("EM"), the Classification E-M ("CEM") and the Stochastic E-M ("SEM"). The default algorithm is the "EM".
}
  \item{d}{
A strictly positive integer. It is the dimension used for common dimension models, note that if this parameter is missing while using this kind of model, an estimation of the dimension is done using Cattell's scree-test on the whole covariance matrix.
}
  \item{init}{
A character string or a vector of class. It is the way to initialize the E-M algorithm. There are five ways of initialization :
\describe{
	\item{\dQuote{param} :}{it is initialized with the parameters, the means being generated by a multivariate normal distribution and the covariance matrix being common to the whole sample}

	\item{\dQuote{mini-em} :}{ it is an initialization strategy, the classes are randomly initialized and the E-M algorithm makes several iterations, this action is repetead a few times, at the end, the initialization choosen is the one which maximise the log-likelihood (see mini.nb for more information)}

	\item{\dQuote{random} :}{ the classes are randomly given}


	\item{\dQuote{kmeans} :}{the classes are initialized using the kmeans algorithm} 
}
It can also be directly initialized with a vector containing the prior classes of the observations.
}
  \item{show}{
Use show=FALSE to settle off the informations that may be printed.
}
  \item{mini.nb}{
A vector of integers of length two. This parameter is used in the "mini-em" initialisation. The first integer sets how many times the algorithm is repeated ; the second sets the maximum number of iterations the algorithm will do each time. For example, if init="mini-em" and mini.nb=c(10,5), for the initialisation process, the algorithm wil be lauched 10 times, doing each time 5 iterations ; finally the algorithm will begin with the initialisation that maximises the log-likelihood. 
}
  \item{scaling}{
Logical : wether to scale the dataset or not.
}
  \item{ctrl}{
The algorithm will stop when the sum of the posterior probabilities of belonging to a class is inferior to ctrl. By default ctrl=1, that means that the algorithm stops when a class has less than 1 percent of the individuals in it.
}
  \item{...}{Any arguments that can be used by the function "kmeans" when this initialization is selected.}
}

\value{
hddc returns an 'hdc' object ; it's a list containing :
\item{ model }{The name of the model.}
\item{ k }{The number of classes.}
\item{ d }{The dimensions of each class.}
\item{ a }{The parameters of each class subspace.}
\item{ b }{The noise of each class subspace.}
\item{ mu }{The mean of each variable for each class.}
\item{ prop }{The proportion of each class.}
\item{ ev }{The eigen values of the var/covar matrix.}
\item{ Q }{The orthogonal matrix of orientation of each class.}
\item{ kname }{The name of each class.}
\item{ BIC }{The BIC value of the model used.}
\item{ scaling }{The centers and the standard deviation of the original dataset.}
\item{ likelihood }{The Log Likelihood for each iteration.}
\item{ class }{The class vector obtained by the clustering.}
\item{ posterior }{The matrix of the probabilities to belong to a class for each observation and each class.}
}
\references{
C. Bouveyron, S. Girard and C. Schmid, High-Dimensional Data Clustering, Computational Statistics and Data Analysis, vol. 52 (1), pp. 502-519, 2007
}
\author{
L. Berge, C. Bouveyron, S. Girard 
}

\seealso{
\code{\link{hdda}}, \code{\link{predict.hdc}}, \code{\link{plot.hdc}}.
}
\examples{
# Example 1 :
datas<-simuldata(1000,1000,50)
X<-datas$X
clx<-datas$clx
Y<-datas$Y
cly<-datas$cly
#clustering of the simulated dataset:
prms1<-hddc(X,k=3,graph=TRUE,algo="CEM",init='param')                
#class vector obtained by the clustering:
prms1$class                
#only to see the good classification rate and the confusion matrix:                                          
res1<-predict(prms1,X,clx)                                            
res2<-predict(prms1,Y)       
#the class predicted using hddc parameters on the test dataset:  
res2$class                                                           

# Example 2 :
data(Crabs)
#clustering of the Crabs dataset:
prms3<-hddc(Crabs[,-1],k=4,graph=TRUE,algo="EM",init='param')        
res3<-predict(prms3,Crabs[,-1],Crabs[,1])

#another example on the Crabs dataset
prms4<-hddc(Crabs[,-1],k=1:8,cgraph=TRUE,model=c(1,2,7,9))
#model=c(1,2,7,9) is equivalent to model=c("AKJBKQKDK","AKBKQKDK","AKJBKQKD","ABKQKD") 
res4<-predict(prms4,Crabs[,-1],Crabs[,1])


}
\keyword{ hddc }
\keyword{ clustering }