% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hddc.R
\name{slopeHeuristic}
\alias{slopeHeuristic}
\title{Slope Heuristic for HDDC objects}
\usage{
slopeHeuristic(x)
}
\arguments{
\item{x}{An \code{hdc} object, obtained from the function \code{\link{hddc}}.}
}
\value{
A list of two elements:
\item{best_model}{The index of the best model, among all estimated models.}
\item{crit}{The slope heuristic criterion for each of the estimated models.}
}
\description{
This function computes the slope heuristic for an
}
\examples{
# Clustering of the Crabs data set
data(Crabs)
prms = hddc(Crabs[,-1], K=1:10)
slope = slopeHeuristic(prms)
plot(slope$crit) # The best model is indeed for 4 clusters
prms$all_results[[slope$best_model]] # we extract the best model


}

