% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hima.R
\name{hima}
\alias{hima}
\title{High-dimensional Mediation Analysis}
\usage{
hima(
  X,
  Y,
  M,
  COV.XM = NULL,
  COV.MY = COV.XM,
  Y.family = c("gaussian", "binomial"),
  M.family = c("gaussian", "negbin"),
  penalty = c("MCP", "SCAD", "lasso"),
  topN = NULL,
  parallel = FALSE,
  ncore = 1,
  scale = TRUE,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{X}{a vector of exposure. Do not use data.frame or matrix.}

\item{Y}{a vector of outcome. Can be either continuous or binary (0-1). Do not use data.frame or matrix.}

\item{M}{a \code{data.frame} or \code{matrix} of high-dimensional mediators. Rows represent samples, columns 
represent variables.}

\item{COV.XM}{a \code{data.frame} or \code{matrix} of covariates dataset for testing the association \code{M ~ X}. 
Covariates specified here will not participate penalization. Default = \code{NULL}. If the covariates 
contain mixed data types, please make sure all categorical variables are properly formatted as \code{factor} type.}

\item{COV.MY}{a \code{data.frame} or \code{matrix} of covariates dataset for testing the association \code{Y ~ M}. 
Covariates specified here will not participate penalization. If not specified, the same set of covariates for 
\code{M ~ X} will be applied. Using different sets of covariates is allowed but this needs to be handled carefully.}

\item{Y.family}{either 'gaussian' (default) or 'binomial', depending on the data type of outcome (\code{Y}). See 
\code{\link{ncvreg}}}

\item{M.family}{either 'gaussian' (default) or 'negbin' (i.e., negative binomial), depending on the data type of
mediator (\code{M}).}

\item{penalty}{the penalty to be applied to the model. Either 'MCP' (the default), 'SCAD', or 
'lasso'. See \code{\link{ncvreg}}.}

\item{topN}{an integer specifying the number of top markers from sure independent screening. 
Default = \code{NULL}. If \code{NULL}, \code{topN} will be either \code{ceiling(n/log(n))} if 
\code{Y.family = 'gaussian'}, or \code{ceiling(n/(2*log(n)))} if \code{Y.family = 'binomial'}, 
where \code{n} is the sample size. If the sample size is greater than topN (pre-specified or calculated), all 
mediators will be included in the test (i.e. low-dimensional scenario).}

\item{parallel}{logical. Enable parallel computing feature? Default = \code{FALSE}.}

\item{ncore}{number of cores to run parallel computing Valid when \code{parallel == TRUE}. 
By default max number of cores available in the machine will be utilized.}

\item{scale}{logical. Should the function scale the data? Default = \code{TRUE}.}

\item{verbose}{logical. Should the function be verbose? Default = \code{FALSE}.}

\item{...}{other arguments passed to \code{\link{ncvreg}}.}
}
\value{
A data.frame containing mediation testing results of selected mediators. 
\itemize{
    \item{alpha: }{coefficient estimates of exposure (X) --> mediators (M).}
    \item{beta: }{coefficient estimates of mediators (M) --> outcome (Y) (adjusted for exposure).}
    \item{gamma: }{coefficient estimates of exposure (X) --> outcome (Y) (total effect).}
    \item{alpha*beta: }{mediation effect.}
    \item{\% total effect: }{alpha*beta / gamma. Percentage of the mediation effect out of the total effect.}
    \item{Bonferroni.p: }{statistical significance of the mediator (Bonferroni procedure).}
    \item{BH.FDR: }{statistical significance of the mediator (Benjamini-Hochberg procedure).}
}
}
\description{
\code{hima} is used to estimate and test high-dimensional mediation effects.
}
\examples{
\dontrun{
# When Y is continuous and normally distributed
# Example 1 (continuous outcome): 
data(Example1)
head(Example1$PhenoData)

hima.fit <- hima(X = Example1$PhenoData$Treatment, 
                 Y = Example1$PhenoData$Outcome, 
                 M = Example1$Mediator,
                 COV.XM = Example1$PhenoData[, c("Sex", "Age")],
                 scale = FALSE,
                 verbose = TRUE) 
hima.fit

# When Y is binary (should specify Y.family)
# Example 2 (binary outcome): 
data(Example2)
head(Example2$PhenoData)

hima.logistic.fit <- hima(X = Example2$PhenoData$Treatment,
                          Y = Example2$PhenoData$Disease,
                          M = Example2$Mediator,
                          COV.XM = Example2$PhenoData[, c("Sex", "Age")],
                          Y.family = 'binomial',
                          scale = FALSE,
                          verbose = TRUE)
hima.logistic.fit
}

}
\references{
Zhang H, Zheng Y, Zhang Z, Gao T, Joyce B, Yoon G, Zhang W, Schwartz J, Just A, Colicino E, Vokonas P, Zhao L, 
Lv J, Baccarelli A, Hou L, Liu L. Estimating and Testing High-dimensional Mediation Effects in Epigenetic Studies. 
Bioinformatics. 2016. DOI: 10.1093/bioinformatics/btw351. PMID: 27357171. PMCID: PMC5048064
}
