#' @title High-Dimensional Mediation Analysis for 'Omic' Data
#'
#' @description
#' HIMA is an R package for estimating and testing high-dimensional mediation effects in omic studies.
#' HIMA can perform high-dimensional mediation analysis on a wide range of omic data types as
#' potential mediators, including epigenetics, transcriptomics, proteomics, and metabolomics using function \code{hima} and 
#' microbiome data (function \code{microHIMA}). HIMA can also handle survival data (function \code{survHIMA}).
#' 
#' \tabular{ll}{ Package: \tab HIMA\cr Type: \tab Package\cr
#' Version: \tab 2.2.1\cr Date: \tab 2023-09-10\cr License: \tab GPL-3\cr }
#' 
#' @name HIMA-package
#' 
#' @aliases HIMA-package HIMA
#' 
#' @docType package
#' 
#' @details 
#' # If package "qvalue" is not found during installation, please first install "qvalue" package
#' # through Bioconductor: https://www.bioconductor.org/packages/release/bioc/html/qvalue.html
#' 
#' @author 
#' Yinan Zheng \email{y-zheng@@northwestern.edu},
#' Haixiang Zhang \email{haixiang.zhang@@tju.edu.cn},  
#' Lifang Hou \email{l-hou@@northwestern.edu}
#' Lei liu \email{lei.liu@@wustl.edu}
#' 
#' Maintainer: Yinan Zheng \email{y-zheng@@northwestern.edu}
#' 
#' @references 1. Zhang H, Zheng Y, Zhang Z, Gao T, Joyce B, Yoon G, Zhang W, Schwartz J, Just A, Colicino E, Vokonas P, Zhao L, 
#' Lv J, Baccarelli A, Hou L, Liu L. Estimating and Testing High-dimensional Mediation Effects in Epigenetic Studies. 
#' Bioinformatics. 2016. DOI: 10.1093/bioinformatics/btw351. PMID: 27357171. PMCID: PMC5048064
#' 
#' 2. Perera C, Zhang H, Zheng Y, Hou L, Qu A, Zheng C, Xie K, Liu L. 
#' HIMA2: high-dimensional mediation analysis and its application in epigenome-wide DNA methylation data. 
#' BMC Bioinformatics. 2022. DOI: 10.1186/s12859-022-04748-1. PMID: 35879655. PMCID: PMC9310002
#' 
#' 3. Zhang H, Zheng Y, Hou L, Zheng C, Liu L. Mediation Analysis for Survival Data with High-Dimensional Mediators. 
#' Bioinformatics. 2021. DOI: 10.1093/bioinformatics/btab564. PMID: 34343267. PMCID: PMC8570823
#' 
#' 4. Zhang H, Chen J, Feng Y, Wang C, Li H, Liu L. Mediation effect selection in high-dimensional and compositional microbiome data. 
#' Stat Med. 2021. DOI: 10.1002/sim.8808. PMID: 33205470; PMCID: PMC7855955
#' 
#' 5. Zhang H, Chen J, Li Z, Liu L. Testing for mediation effect with application to human microbiome data. 
#' Stat Biosci. 2021. DOI: 10.1007/s12561-019-09253-3. PMID: 34093887; PMCID: PMC8177450
#' 
#' 6. Zhang H, Hong X, Zheng Y, Hou L, Zheng C, Wang X, Liu L. High-Dimensional Quantile Mediation Analysis with Application to a Birth 
#' Cohort Study of Mother–Newborn Pairs. Bioinformatics. 2023. (In press)
#' 
#' @keywords package
#' 
#' @import ncvreg
#' @import glmnet
#' 
#' @importFrom utils packageVersion
#' @importFrom stats p.adjust rnorm runif rbinom lm glm model.matrix BIC coef ls.diag lsfit pnorm complete.cases rgamma
#' @importFrom iterators idiv nextElem
#' @importFrom parallel detectCores
#' @importFrom foreach foreach %dopar% registerDoSEQ getDoParWorkers
#' @importFrom doParallel registerDoParallel
#' @importFrom HDMT fdr_est
#' @importFrom hdi lasso.proj
#' @importFrom conquer conquer.cv.reg
#' @importFrom quantreg rq
#' @importFrom survival Surv coxph
#' @importFrom MASS mvrnorm glm.nb
#' @importFrom hommel hommel discoveries
#' 
NULL