% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qHIMA.R
\name{qHIMA}
\alias{qHIMA}
\title{High-dimensional quantile mediation analysis}
\usage{
qHIMA(
  X,
  M,
  Y,
  Z,
  penalty = c("MCP", "SCAD", "lasso"),
  topN = NULL,
  tau = 0.5,
  scale = TRUE,
  Bonfcut = 0.05,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{X}{a vector of exposure.}

\item{M}{a \code{data.frame} or \code{matrix} of high-dimensional mediators. Rows represent samples, columns 
represent mediator variables.}

\item{Y}{a vector of continuous outcome. Do not use data.frame or matrix.}

\item{Z}{a matrix of adjusting covariates. Rows represent samples, columns represent variables. Can be \code{NULL}.}

\item{penalty}{the penalty to be applied to the model (a parameter passed to function \code{conquer.cv.reg} in package \code{\link{conquer}}. 
Either 'MCP' (the default), 'SCAD', or 'lasso'.}

\item{topN}{an integer specifying the number of top markers from sure independent screening. 
Default = \code{NULL}. If \code{NULL}, \code{topN} will be \code{2*ceiling(n/log(n))}, where \code{n} is the sample size.
If the sample size is greater than topN (pre-specified or calculated), all mediators will be included in the test (i.e. low-dimensional scenario).}

\item{tau}{quantile level of outcome. Default = 0.5. A vector of tau is accepted.}

\item{scale}{logical. Should the function scale the data? Default = \code{TRUE}.}

\item{Bonfcut}{Bonferroni-corrected p value cutoff applied to define and select significant mediators. Default = \code{0.05}.}

\item{verbose}{logical. Should the function be verbose? Default = \code{FALSE}.}

\item{...}{other arguments.}
}
\value{
A data.frame containing mediation testing results of selected mediators (Bonferroni-adjusted p value <\code{Bonfcut}). 
\itemize{
    \item{ID: }{index of selected significant mediator.}
    \item{alpha: }{coefficient estimates of exposure (X) --> mediators (M).}
    \item{alpha_se: }{standard error for alpha.}
    \item{beta: }{coefficient estimates of mediators (M) --> outcome (Y) (adjusted for exposure).}
    \item{beta_se: }{standard error for beta.}
    \item{Bonferroni.p: }{statistical significance of the mediator (Bonferroni-corrected p value).}
}
}
\description{
\code{qHIMA} is used to estimate and test high-dimensional quantile mediation effects.
}
\examples{
\dontrun{
# Note: In the following example, M1, M2, and M3 are true mediators.
data(himaDat)

head(himaDat$Example5$PhenoData)

qHIMA.fit <- qHIMA(X = himaDat$Example5$PhenoData$Treatment,
                M = himaDat$Example5$Mediator, 
                Y = himaDat$Example5$PhenoData$Outcome, 
                Z = himaDat$Example5$PhenoData[, c("Sex", "Age")], 
                Bonfcut = 0.05,
                tau = c(0.3, 0.5, 0.7),
                scale = FALSE, 
                verbose = TRUE)
qHIMA.fit
}

}
\references{
Zhang H, Hong X, Zheng Y, Hou L, Zheng C, Wang X, Liu L. High-Dimensional Quantile Mediation Analysis with Application to a Birth 
Cohort Study of Mother–Newborn Pairs. Bioinformatics. 2023. (In press)
}
