\name{generateTree}
\alias{generateTree}
\title{Generate Test Trees}
\description{This function will take several initial trees and will randomly populate new trees based on the originals.}

\usage{generateTree(data, nreads = 10000, nsamps = 50, theta = 0, level = "genus", split = ".")}

\arguments{
  \item{data}{A data frame in which each column contains the rdp read counts for every taxa given in the row names.}
  \item{nreads}{The maximum number of reads the created a tree will contain.}
  \item{nsamps}{The number of trees to generate.}
  \item{theta}{When theta is between 0 and 1 the base tree is generated by using the \code{dirmult} function and modified by 
  		the theta value, otherwise the base tree is generated by the \code{DM.MoM} function.}
  \item{level}{The depth the tree will go down to (kingdom, phylum, class, order, family, genus, species, subspecies). Genus is the default.}
  \item{split}{This is the character that separates the taxa levels in the row names.}
}

\details{This functions requires that the package \code{HMP} be installed.}

\value{A data frame containing the generated tree(s).}
\author{Patricio S. La Rosa, Elena Deych, Berkley Shands, William D. Shannon}

\examples{
	data(saliva)
	
	gendata <- generateTree(saliva, 7000, 2)
}