
[![minimal R
version](https://img.shields.io/badge/R%3E%3D-3.5.3-6666ff.svg)](https://cran.r-project.org/)
[![GitHub
(pre-)release](https://img.shields.io/github/release/timtrice/HURDAT/all.svg)](https://github.com/timtrice/HURDAT/tags)
[![CRAN\_Status\_Badge](http://www.r-pkg.org/badges/version/HURDAT)](https://cran.r-project.org/package=HURDAT)
[![Build
Status](https://img.shields.io/travis/timtrice/HURDAT/master.svg)](https://travis-ci.org/timtrice/HURDAT)
[![AppVeyor Build
Status](https://img.shields.io/appveyor/ci/timtrice/HURDAT/master.svg)](https://ci.appveyor.com/project/timtrice/HURDAT)
[![codecov](https://codecov.io/gh/timtrice/HURDAT/branch/master/graph/badge.svg)](https://codecov.io/gh/timtrice/HURDAT)
[![Docker Build
Status](https://img.shields.io/docker/build/timtrice/hurdat.svg)](https://cloud.docker.com/repository/docker/timtrice/hurdat)
[![rstudio.cloud](https://img.shields.io/badge/launch-rstudio.cloud-yellowgreen.svg)](https://rstudio.cloud/project/407354)

# HURDAT

This R package currently aims to reorganize the NOAA HURDAT2 dataset for
Atlantic, East Pacific and Central Pacific-basin tropical cyclones and
present it in a cleaner format.

The Atlantic basin dataset covers all cyclones that have developed in
the Atlantic Ocean. The eastern Pacific datasets cover cyclones in the
Pacifc from the United States/Mexico coastlines to -140°W where the
cyclone entered what is referred to as the central Pacific basin. The
central Pacific basin extends westward to -180°W.

## Getting Started

Please view the vignette ‘hurdat’:

``` r
vignette("hurdat", package = "HURDAT")
```

### Installing

`HURDAT` is available on CRAN.

``` r
install.packages("HURDAT")
```

## Built With

  - [R 3.4.0](https://www.r-project.org/) - The R Project for
    Statistical Computing

## Contributing

Please read
[CONTRIBUTING.md](https://github.com/timtrice/HURDAT/blob/master/.github/CONTRIBUTING.md)
for details on our code of conduct, and the process for submitting pull
requests to us.

## Versioning

We use [SemVer](http://semver.org/) for versioning. For the versions
available, see the [tags on this
repository](https://github.com/timtrice/HURDAT/tags).

## Authors

  - **Tim Trice** - *Initial work* -
    [timtrice](https://github.com/timtrice)

See also the list of
[contributors](https://github.com/timtrice/HURDAT/contributors) who
participated in this project.

## License

This project is licensed under the MIT License - see the
[LICENSE](https://github.com/timtrice/HURDAT/blob/master/LICENSE.md)
file for details

## Acknowledgments

  - None yet
