% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functioncollection_import.R
\name{ReadInfo}
\alias{ReadInfo}
\title{Read an 'info.txt' file}
\usage{
ReadInfo(filename = "info.txt", encoding = c("unknown", "UTF-8", "latin1"))
}
\arguments{
\item{filename}{Path to and file name of the info.txt file to import.}

\item{encoding}{Character string, encoding of non-ascii characters in imported text file. Particularly relevant when
importing files created under Windows (default encoding "Latin-1") in Linux (default encoding "UTF-8") and vice versa. See
also argument description in \code{\link{scan}}.}
}
\value{
\code{ReadInfo} returns a named list. List names are settings codes
(see \href{http://www.smhi.net/hype/wiki/doku.php?id=start:hype_file_reference:info.txt}{info.txt documentation}). Settings with two
codes are placed in nested lists, e.g. \code{myinfo$basinoutput$variable}. Multi-line subbasin definitions for basin outputs and class
outputs are merged to single vectors on import.
}
\description{
Import a HYPE model settings information file as list into R.
}
\details{
\code{ReadInfo} discards all comments of the imported file (comment rows and in-line comments). The function's purpose is to quickly
provide access to settings and details of a model run, not to mirror the exact info.txt file structure into an R data object. No
corresponding export function exists.
}
\examples{
te <- ReadInfo(filename = system.file("demo_model",
"info.txt", package = "HYPEtools"))
te

}
