% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functioncollection_import.R
\name{ReadSubass}
\alias{ReadSubass}
\title{Read a 'subassX.txt' file}
\usage{
ReadSubass(
  filename = "subass1.txt",
  nhour = NULL,
  check.names = FALSE,
  na.strings = c("****************", "-9999")
)
}
\arguments{
\item{filename}{Path to and file name of the 'subassX.txt' file to import.}

\item{nhour}{Integer, time step of sub-daily model results in hours. See details.}

\item{check.names}{Logical. If \code{TRUE}, then the names of the variables are check to make sure they are syntactically valid.}

\item{na.strings}{Vector of strings that should be read as NA.}
}
\value{
\code{ReadSubass} returns a data frame with two additional attributes: \code{variables} contains a 2-element
character vector with IDs of evaluated observed and simulated HYPE variables, \code{timestep} contains a character
keyword detailing the evaluation time step.
}
\description{
This is a convenience wrapper function to import an subassX.txt sub-basin assessment file as data frame into R.
Sub-basins assessment files contain performance criteria results, as defined in 'info.txt', for individual
sub-basins with observations.
}
\details{
\code{ReadSubass} imports a sub-basin assessment file into R. Information on model variables evaluated in the
file is imported as additional \code{\link{attributes}} \code{variables}, the evaluation time step in an attribute
\code{timestep}.

Sub-daily time steps are reported with time step code '0' in HYPE result files. In order to preserve the time step
information in the imported R object, users must provide the actual model evaluation time step in hours
in argument \code{nhour} in the sub-daily case.
}
\examples{
te <- ReadSubass(filename = system.file("demo_model",
"results", "subass1.txt", package = "HYPEtools"))
te

}
