% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rSnbinom.R
\name{rSnbinom}
\alias{rSnbinom}
\title{Random generation for the sum of random variable with negative binomial distributions.}
\usage{
rSnbinom(n = 1, size = NULL, prob = NULL, mu = NULL)
}
\arguments{
\item{n}{number of observations.}

\item{size}{target for number of successful trials, or dispersion parameter (the shape parameter of the gamma mixing distribution). Must be strictly positive, need not be integer.}

\item{prob}{probability of success in each trial. 0 < prob <= 1.}

\item{mu}{alternative parametrization via mean.}
}
\value{
rSnbinom returns random number
}
\description{
Random numbers for the sum of random variable with negative binomial distributions.
}
\details{
rSnbinom returns random numbers for the sum of random variable with negative binomial distributions
}
\examples{
\dontrun{
alpha <- c(2.1, 2.05, 2)
mu <- c(10, 30, 20)
rep <- 100000
distEmpirique <- rSnbinom(n=rep, size=alpha, mu=mu)
tabledistEmpirique <- rep(0, 301)
names(tabledistEmpirique) <- as.character(0:300)
tabledistEmpirique[names(table(distEmpirique))] <- table(distEmpirique)/rep

plot(0:300, dSnbinom(0:300, size=alpha, mu=mu), type="h", bty="n", 
   xlab="x", ylab="Density", ylim=c(0,0.02))
plot_add(0:300, tabledistEmpirique, type="l", col="red")
legend(x=200, y=0.02, legend=c("Empirical", "Theoretical"), 
   text.col=c("red", "black"), bty="n")
}
}
\seealso{
Other Distribution of sum of random variable with negative binomial distributions: 
\code{\link{dSnbinom}()},
\code{\link{pSnbinom}()},
\code{\link{qSnbinom}()}
}
\author{
Marc Girondot \email{marc.girondot@gmail.com}
}
\concept{Distribution of sum of random variable with negative binomial distributions}
