% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/principal_components.R
\name{WH.plot_multiple_Spanish.funs}
\alias{WH.plot_multiple_Spanish.funs}
\title{Plotting Spanish fun plots for Multiple factor analysis of Histogram Variables}
\usage{
WH.plot_multiple_Spanish.funs(res, axes = c(1, 2), var = 1, LABS = TRUE,
  multi = TRUE, corplot = TRUE)
}
\arguments{
\item{res}{Results from WH.MultiplePCA, or WH.1D.PCA.}

\item{axes}{A list of  integers, the new factorial axes c(1,2) are the default.}

\item{var}{A list of integers are the variables to plot.}

\item{LABS}{Logical, if TRUE graph is labeled, otherwise it does not.}

\item{multi}{Logical, if TRUE (default) results come from a WH.MultiplePCA,
if FALSE results come from WH.1D.PCA.}

\item{corplot}{Logical, if TRUE (default) the plot reports correlations, if FALSE
the coordinates of quantiles on the factorial plane}
}
\value{
a plot of class ggplot
}
\description{
The function plots the circle of correlation of the quantiles
of the histogrma variables after a Multiple factor analysis.
}
\examples{
#Do a MultiplePCA on the BLOOD dataset
res=WH.MultiplePCA(BLOOD,list.of.vars = c(1:3)) 
#Plot results
WH.plot_multiple_Spanish.funs(res,axes=c(1,2),var=c(1:3))
}

