% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plotHostSwitch}
\alias{plotHostSwitch}
\title{HostSwitch standard plot}
\usage{
plotHostSwitch(HostSwitch_simulated_quantities, sim_n = 1)
}
\arguments{
\item{HostSwitch_simulated_quantities}{The object HostSwitch created by \code{\link{simHostSwitch}}}

\item{sim_n}{for HostSwitch object including more than 1 simulation saved, "sim_n" specifies which simulation have to be plotted. The plot from the first simulation is shown as default (sim_n = 1). If the called simulation number is not present in the HostSwitch object, the error message "Error in FUN(X[[i]], ...) : subscript out of bounds" will be returned.}
}
\value{
An S3 object with class gg/ggplot
}
\description{
This function creates a standard plot for the simulated host switches
}
\details{
The function plots dispersal and colonization (host-switching events) of Consumers on a novel host offered at each generation given the values of parameters related to carrying capacity, fitness space, migration, reproduction, selection, and biological model. The X-axis shows the total number of possible generations defined in the object HostSwitch, the Y-axis the phenotype values of the Consumer.

Black dots are the phenotype values of the Consumer after each event of reproduction. The green squares represent the value of phenotype favored by the novel Resource offered at each generation. The red squares are the phenotype values of the Consumer favored by the current Resource.The blue dots represents the phenotypes of dispersing Consumers, and the yellow dots the successfully colonizing Consumers.
}
\examples{
m1 = simHostSwitch(n_sim=100) # create an HostSwitch object with 100 simulations.

## The results of the first simulation (sim_n=1) are plotted as default
plotHostSwitch(m1)

## The 50th simulation of the model is plotted
plotHostSwitch(m1,sim_n=50)

}
