% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fooTp.R
\name{uTp}
\alias{uTp}
\title{Specific Internal Energy, Function of Temperature and Pressure}
\usage{
uTp(T, p)
}
\arguments{
\item{T}{Temperature [ K ]}

\item{p}{Pressure [ MPa ]}
}
\value{
The Specific Internal Energy: u [ kJ kg-1 ] and an Error message 
    (if an error occur: \link{errorCodes})
}
\description{
The function \code{uTp(T,p)} returns the Specific Internal Energy, h [ kJ kg-1 ],
     for given T [K] and D [kg/m3].
}
\details{
This function calls a Fortran DLL that solves the Helmholtz Energy Equation. 
    in accordance with the Revised Release on the IAPWS Formulation 1995 for the 
    Thermodynamic Properties of Ordinary Water Substance for General and Scientific
    Use (June 2014) developed by the International Association for the Properties of
    Water and Steam,  \url{http://www.iapws.org/relguide/IAPWS-95.html}. It is valid  
    from the triple point to the pressure of 1000 MPa and temperature of 1273.
}
\examples{
T <- 500.
p <- 10.0003858
u <- uTp(T,p)
u

}
