% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Td2M.R
\name{getTidyForm}
\alias{getTidyForm}
\title{Matrix format to Tidy data format}
\usage{
getTidyForm(Matrix_DataSet, onlyTrait = F)
}
\arguments{
\item{Matrix_DataSet}{A data.frame object with the response values divided in \eqn{n} environments or traits columns}

\item{onlyTrait}{\code{logical} by default is \code{FALSE}, if is \code{TRUE} only is considered the \code{$Trait} column.}
}
\value{
A \code{data.frame} object with the \code{$Response} divided by \code{$Traits} columns.
}
\description{
Matrix format to Tidy data format
}
\examples{
\dontrun{
  data('Wheat_IBCF')
  M <- getMatrixForm(Wheat_IBCF)
  Tidy <- getTidyForm(M)
}

\dontrun{
  data('Year_IBCF')
  M.Y <- getMatrixForm(Year_IBCF, onlyTrait = T)
  Tidy.Y <- getTidyForm(M.Y, onlyTrait = T)
}

}
