% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VCF_to_catalog_functions.R
\name{ReadAndSplitStrelkaSBSVCFs}
\alias{ReadAndSplitStrelkaSBSVCFs}
\title{Read and split Strelka SBS VCF files.}
\usage{
ReadAndSplitStrelkaSBSVCFs(files, names.of.VCFs = NULL)
}
\arguments{
\item{files}{Character vector of file paths to the Strelka SBS VCF files.}

\item{names.of.VCFs}{Character vector of names of the VCF files. The order
of names in \code{names.of.VCFs} should match the order of VCF file paths
in \code{files}. If \code{NULL}(default), this function will remove all of
the path up to and including the last path separator (if any) and file
paths without extensions (and the leading dot) will be used as the names of
the VCF files.}
}
\value{
A list of 3 in-memory objects as follows:
\enumerate{
   \item \code{SBS.vcfs} List of data.frames of pure SBS mutations -- no DBS or 3+BS mutations.

   \item \code{DBS.vcfs} List of data.frames of pure DBS mutations -- no SBS or 3+BS mutations.

   \item \code{ThreePlus} List of data.tables with the key CHROM, LOW.POS, HIGH.POS. containing
   rows that that in the input that did not represent SBSs or DBSs.

   }
}
\description{
Read and split Strelka SBS VCF files.
}
\examples{
file <- c(system.file("extdata",
                      "Strelka.SBS.GRCh37.vcf",
                      package = "ICAMS"))
list.of.vcfs <- ReadAndSplitStrelkaSBSVCFs(file)
}
\seealso{
\code{\link{StrelkaSBSVCFFilesToCatalog}}
}
