% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VCF_to_catalog_functions.R
\name{StrelkaIDVCFFilesToCatalogAndPlotToPdf}
\alias{StrelkaIDVCFFilesToCatalogAndPlotToPdf}
\title{Create ID (indel) catalog from Strelka ID VCF files and plot them to PDF}
\usage{
StrelkaIDVCFFilesToCatalogAndPlotToPdf(files, ref.genome,
  region = "unknown", output.file)
}
\arguments{
\item{files}{Character vector of file paths to the Strelka ID VCF files.}

\item{ref.genome}{A \code{ref.genome} argument as described in
\code{\link{ICAMS}}.}

\item{region}{A character string designating a genomic region;
see \code{\link{as.catalog}} and \code{\link{ICAMS}}.}

\item{output.file}{The name of the PDF file to be produced.}
}
\value{
An ID (indel) catalog and its graph plotted to PDF with specified
  file name. The ID (indel) catalog has attributes added. See
  \code{\link{as.catalog}} for more details.
}
\description{
Create ID (indel) catalog from the Strelka ID VCFs specified by \code{files}
and plot them to PDF
}
\details{
This function calls \code{\link{StrelkaIDVCFFilesToCatalog}} and
\code{\link{PlotCatalogToPdf}}
}
\note{
In ID (insertion and deletion) catalogs, deletion repeat sizes
  range from 0 to 5+, but for plotting and end-user documentation
  deletion repeat sizes range from 1 to 6+.
}
\examples{
file <- c(system.file("extdata",
                      "Strelka.ID.GRCh37.vcf",
                      package = "ICAMS"))
catID <- 
  StrelkaIDVCFFilesToCatalogAndPlotToPdf(file, ref.genome = "hg19", 
                                         region = "genome",
                                         output.file = file.path(tempdir(), 
                                                                 "StrelkaID.pdf"))
}
