% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/INDELS_related_functions.R
\name{VCFsToIDCatalogs}
\alias{VCFsToIDCatalogs}
\title{Create ID (insertion and deletion) catalog from ID VCFs}
\usage{
VCFsToIDCatalogs(list.of.vcfs, ref.genome, region = "unknown")
}
\arguments{
\item{list.of.vcfs}{List of in-memory VCFs. The list names will be
the sample ids in the output catalog.}

\item{ref.genome}{A \code{ref.genome} argument as described in
\code{\link{ICAMS}}.}

\item{region}{A character string acting as a region identifier, one of
"genome", "exome".}
}
\value{
An S3 object containing an ID (indel) catalog with class
  "catalog". See \code{\link{as.catalog}} for more details.
}
\description{
Create ID (insertion and deletion) catalog from ID VCFs
}
\note{
In ID (insertion and deletion) catalogs, deletion repeat sizes
  range from 0 to 5+, but for plotting and end-user documentation
  deletion repeat sizes range from 1 to 6+.
}
\examples{
file <- c(system.file("extdata",
                      "Mutect.GRCh37.vcf",
                      package = "ICAMS"))
list.of.ID.vcfs <- ReadAndSplitMutectVCFs(file)$ID
if (requireNamespace("BSgenome.Hsapiens.1000genomes.hs37d5", quietly = TRUE)) {
  catID <- VCFsToIDCatalogs(list.of.ID.vcfs, ref.genome = "hg19",
                            region = "genome")}
}
