% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{FIM_exp_2par}
\alias{FIM_exp_2par}
\title{Fisher information matrix for the two-parameter exponential model.}
\usage{
FIM_exp_2par(x, w, param)
}
\arguments{
\item{x}{vector of design points.}

\item{w}{vector of design weight. Its length must be equal to the length of \code{x} and \code{sum(w)} should be 1.}

\item{param}{vector of model parameters \eqn{\bold{\theta} = (a, b)}.}
}
\value{
Fisher information matrix.
}
\description{
The mean of response variable is \deqn{f(x, \bold{\theta}) = a + \exp(-bx)}.
}
\details{
The Fisher information matrix does not depend on \code{a}.\cr
The locally D optimal design is independent of the nominal
value of \eqn{a} and is equally supported at \eqn{x = 0} and \eqn{x = 1/b}
 only when \eqn{x \in [0, 1]}{{x belongs to [0, 1]}}. See "Examples".
}
\examples{
\dontrun{
### finding the locally optimal design for different values for design interval
mica(fimfunc = "FIM_exp_2par", lx = 0, ux = 1, lp = c(1, 2), up = c(1, 2),
     iter = 100, k = 2, type = "locally", control = list(seed = 215))

mica(fimfunc = "FIM_exp_2par", lx = .0001, ux = 1, lp = c(1, 2), up = c(1, 2),
     iter = 100, k = 2, type = "locally", control = list(seed = 215))

mica(fimfunc = "FIM_exp_2par", lx = 0, ux = 10, lp = c(1, 2), up = c(1, 2),
     iter = 100, k = 2, type = "locally", control = list(seed = 215))

mica(fimfunc = "FIM_exp_2par", lx = .0001, ux = 10, lp = c(1, 2), up = c(1, 2),
     iter = 100, k = 2, type = "locally", control = list(seed = 215))

## it seems for design interval x = [x_l, x_u], when x_l > 0,
## the locally D-optimal design is a two-point equally weighted design
## with x1 = x_l, x2 = x_u

mica(fimfunc = "FIM_exp_2par", lx = .5, ux = 10, lp = c(1, 2), up = c(1, 2),
     iter = 100, k = 2, type = "locally", control = list(seed = 215))

mica(fimfunc = "FIM_exp_2par", lx = .0001, ux = 10, lp = c(1, 2), up = c(1, 2),
     iter = 100, k = 2, type = "locally", control = list(seed = 215))

mica(fimfunc = "FIM_exp_2par", lx = 1, ux = 10, lp = c(1, 2), up = c(1, 2),
        iter = 100, k = 2, type = "locally", control = list(seed = 215))


mica(fimfunc = "FIM_exp_2par", lx = 2, ux = 10, lp = c(1, 2), up = c(1, 2),
     iter = 100, k = 2, type = "locally", control = list(seed = 215))

mica(fimfunc = "FIM_exp_2par", lx = 3, ux = 9, lp = c(1, 2), up = c(1, 2),
     iter = 100, k = 2, type = "locally", control = list(seed = 215))

}
}
\references{
Dette, H., & Neugebauer, H. M. (1997). Bayesian D-optimal designs for exponential regression models. Journal of Statistical Planning and Inference, 60(2), 331-349.
}
\seealso{
Other FIM: \code{\link{FIM_comp_inhibition}},
  \code{\link{FIM_emax_3par}}, \code{\link{FIM_exp_3par}},
  \code{\link{FIM_logisitic_1par}},
  \code{\link{FIM_logistic_4par}},
  \code{\link{FIM_logistic}}, \code{\link{FIM_loglin}},
  \code{\link{FIM_michaelis}},
  \code{\link{FIM_mixed_inhibition}},
  \code{\link{FIM_noncomp_inhibition}},
  \code{\link{FIM_power_logistic}},
  \code{\link{FIM_uncomp_inhibition}}
}

