% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ICcforest.R
\name{ICcforest}
\alias{ICcforest}
\title{Fit a conditional inference forest for interval-censored survival data}
\usage{
ICcforest(formula, data, mtry = NULL, ntree = 100L, applyfun = NULL,
  cores = NULL, na.action = na.pass, suppress = TRUE, trace = TRUE,
  perturb = list(replace = FALSE, fraction = 0.632),
  control = partykit::ctree_control(teststat = "quad", testtype = "Univ",
  mincriterion = 0, saveinfo = FALSE, minsplit = nrow(data) * 0.15,
  minbucket = nrow(data) * 0.06), ...)
}
\arguments{
\item{formula}{a formula object, with the response being a \code{\link[survival]{Surv}} object, 
with form


\code{Surv(time1, time2, type="interval2")}.}

\item{data}{a data frame containing the variables named in \code{formula}.}

\item{mtry}{number of input variables randomly sampled as candidates at each node for 
random forest like algorithms. The default \code{mtry} is tuned by \code{\link{tuneICRF}}.}

\item{ntree}{an integer, the number of the trees to grow for the forest. \code{ntree = 100L} is set 
by default.}

\item{applyfun}{an optional \code{lapply}-style function with arguments 
\code{function(X, FUN, ...)}. 
It is used for computing the variable selection criterion. The default is to use the
basic \code{lapply} function unless the \code{cores} argument is specified (see below). 
See \code{\link[partykit]{ctree_control}}.}

\item{cores}{numeric. If set to an integer the \code{applyfun} is set to \code{\link[parallel]{mclapply}} 
with the desired number of cores. See \code{\link[partykit]{ctree_control}}.}

\item{na.action}{a function which indicates what should happen when the data contain 
missing values.}

\item{suppress}{a logical specifying whether the messages from \code{\link[icenReg]{getFitEsts}} 
are suppressed. If \code{FALSE}, the messages are printed. \code{suppress = TRUE} is set by default.}

\item{trace}{whether to print the progress of the search of the optimal value of \code{mtry}
when \code{mtry} is not specified (see \code{\link{tuneICRF}}). \code{trace = TRUE} is set by default.}

\item{perturb}{a list with arguments \code{replace} and \code{fraction} determining which 
type of resampling, with \code{replace = TRUE} referring to the n-out-of-n 
bootstrap and \code{replace = FALSE} referring to sample splitting. \code{fraction} is 
the proportion of observations to draw without replacement.}

\item{control}{a list of control parameters, see \code{\link[partykit]{ctree_control}}.
\code{control} parameters \code{minsplit}, \code{minbucket} have been adjusted from the 
\code{\link[partykit]{cforest}} defaults. Other default values correspond to those of the 
default values used by \code{\link[partykit]{ctree_control}}.}

\item{...}{additional arguments.}
}
\value{
An object of class \code{ICcforest}, as a subclass of \code{\link[partykit]{cforest}}.
}
\description{
An implementation of the random forest and bagging ensemble algorithms utilizing conditional 
inference trees as base learners for interval-censored survival data.
}
\details{
\code{ICcforest} returns an \code{ICcforest} object.
The object belongs to the class \code{ICcforest}, as a subclass of \code{\link[partykit]{cforest}}.
This function extends the conditional inference survival forest algorithm in 
\code{\link[partykit]{cforest}} to fit interval-censored survival data.
}
\examples{
#### Example with miceData
library(icenReg)
data(miceData)

## For ICcforest to run, Inf should be set to be a large number, for example, 9999999.
miceData$u[miceData$u == Inf] <- 9999999.

## Fit an iterval-censored conditional inference forest
Cforest <- ICcforest(Surv(l, u, type = "interval2") ~ grp, data = miceData)

}
\seealso{
\code{\link{predict.ICcforest}} for prediction, \code{\link{gettree.ICcforest}}
for individual tree extraction, and \code{\link{tuneICRF}} for \code{mtry} tuning.
}
\keyword{Ensemble}
\keyword{conditional}
\keyword{data}
\keyword{forest,}
\keyword{inference}
\keyword{interval-censored}
\keyword{method,}
