% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IDEfunctions.R
\name{simIDE}
\alias{simIDE}
\title{Simulate datasets from the IDE model}
\usage{
simIDE(T = 9, nobs = 100, k_spat_invariant = 1)
}
\arguments{
\item{T}{number of time points to simulate}

\item{nobs}{number of observations randomly scattered in the domain and fixed for all time intervals}

\item{k_spat_invariant}{flag indicating whether to simulate using a spatially-invariant kernel or a spatially-variant one}
}
\value{
A list containing the simulated process in \code{s_df}, the simulated data in \code{z_df}, the data as \code{STIDF} in \code{z_STIDF}, plots of the process and the observations in \code{g_truth} and \code{g_obs}, and the IDE model used to simulate the process and data in \code{IDEmodel}.
}
\description{
Generates simulations that are then used to evaluate the fitting and prediction of an IDE model.
}
\details{
The domain considered is [0,1] x [0,1], and an IDE is simulated on top of a fixed effect comprising of an intercept, a linear horizontal effect, and a linear vertical effect (all with coefficients 0.2). The measurement-error variance and the variance of the additive disturbance are both 0.0001. When a spatially-invariant kernel is used, the following parameters are fixed: \eqn{\theta_{p,1} = 150}, \eqn{\theta_{p,2} = 0.002}, \eqn{\theta_{p,3} = -0.1}, and \eqn{\theta_{p,4} = 0.1}. See \code{\link{IDE}} for details on these parameters. When a spatially-varying kernel is used, \eqn{\theta_{p,1} = 200}, \eqn{\theta_{p,2} = 0.002}, and \eqn{\theta_{p,3}(s), \theta_{p,4}(s)} are smooth spatial functions simulated on the domain.
}
\examples{
SIM1 <- simIDE(T = 5, nobs = 100, k_spat_invariant = 1)
SIM2 <- simIDE(T = 5, nobs = 100, k_spat_invariant = 0)
}
\seealso{
\code{\link{show_kernel}} for plotting the kernel and \code{\link{IDE}}
}
